#!/bin/bash
set -e

ln -sf /bin/bash /bin/sh
ln -sf /proc/mounts /etc/mtab

# Add path to Carton libs for log4perl (#PI-18283)
export PERL5LIB="/usr/share/partners/local/lib/perl5:$PERL5LIB"

env | awk -F '=' '{system("sed --in-place \"/^$1/d\" /etc/security/pam_env.conf || true")}'
env | awk -F '=' '{print $1 " DEFAULT=\"" $2 "\""}' >> /etc/security/pam_env.conf

touch /var/log/partners.yandex.ru/partner2_edit_page.log
touch /var/log/partners.yandex.ru/partner2_main.log
touch /var/log/partners.yandex.ru/partner2_mol.log
touch /var/log/partners.yandex.ru/partner2_rosetta.log
chown partners:www-data /var/log/partners.yandex.ru/partner2_edit_page.log
chown partners:www-data /var/log/partners.yandex.ru/partner2_main.log
chown partners:www-data /var/log/partners.yandex.ru/partner2_mol.log
chown partners:www-data /var/log/partners.yandex.ru/partner2_rosetta.log

if [[ "$DEPLOY_UNIT_ID" == "Crons" ]]; then
    if [[ "$ENVIRONMENT" == "PREPROD" ]]; then
        cp /opt/yandex-partners-cron-preprod /etc/cron.d/yandex-partners-cron
    elif [[ "$ENVIRONMENT" == "TESTING" ]]; then
        cp /opt/yandex-partners-cron-ts /etc/cron.d/yandex-partners-cron
    elif [[ "$ENVIRONMENT" == "PRODUCTION" ]]; then
        cp /opt/yandex-partners-cron-prod /etc/cron.d/yandex-partners-cron
    else
        echo "ERROR: Unknown environment $ENVIRONMENT"
        exit 1
    fi
else
    if [[ "$ENVIRONMENT" == "PREPROD" ]]; then
        cp /opt/yandex-partners-frontend-cron-preprod /etc/cron.d/yandex-partners-frontend-cron
    elif [[ "$ENVIRONMENT" == "TESTING" ]]; then
        cp /opt/yandex-partners-frontend-cron-ts /etc/cron.d/yandex-partners-frontend-cron
    elif [[ "$ENVIRONMENT" == "AUTOTEST" ]]; then
        cp /opt/yandex-partners-frontend-cron-autotest /etc/cron.d/yandex-partners-frontend-cron
    elif [[ "$ENVIRONMENT" == "PRODUCTION" ]]; then
        cp /opt/yandex-partners-frontend-cron-prod /etc/cron.d/yandex-partners-frontend-cron
    else
        echo "ERROR: Unknown environment $ENVIRONMENT"
        exit 1
    fi
fi
