#!/bin/bash

# define agent environment variables or default
AGENT_NAME="${DEPLOY_POD_ID}.${AGENT_SUFFIX}.yandex-team.ru"
AGENT_HOME="/usr/local/teamcity-agents/${AGENT_NAME}"
AGENT_LOG="${AGENT_HOME}/logs"

/etc/init.d/teamcity-agent restart ${AGENT_NAME}

# Wait for agent start to write log
while [ ! -f ${AGENT_LOG}/teamcity-agent.log ];
do
   echo -n "."
   sleep 1
done

trap '$(save_build_agent_authorization_token); ${AGENT_HOME}/bin/agent.sh stop force; while ps -p $(cat $(ls -1 ${AGENT_LOG}/*.pid)) &>/dev/null; do sleep 1; done; kill %%' SIGINT SIGTERM SIGHUP

tail -qF ${AGENT_LOG}/teamcity-agent.log &
wait
