#!/bin/bash
set -e

# https://docs.yandex-team.ru/classifieds-infra/deploy/secret#vazhnye-osobennosti
mkdir -p /root/.ssh/
echo $ROBOT_PARTNER_ID_RSA | base64 --decode > /root/.ssh/id_rsa
chmod 0600 /root/.ssh/id_rsa

# prepare for teamcity
cp /root/.ssh/id_rsa /home/teamcity/.ssh/id_rsa
chown teamcity /home/teamcity/.ssh/id_rsa

mkdir -p /arc
eval `ssh-agent -s`
ssh-add -k /root/.ssh/id_rsa
if [ -d /root/.ssh/known_hosts ]; then
  ssh-keygen -R arcadia.yandex.ru;
fi
ssh-keyscan -H arcadia.yandex.ru >> /root/.ssh/known_hosts
svn co --depth empty svn+ssh://robot-partner@arcadia.yandex.ru/arc/trunk/arcadia/ /root/yatool && svn up /root/yatool/ya
/root/yatool/ya clone --no-junk /arc/arcadia --repo=svn+ssh://robot-partner@arcadia.yandex.ru/
cd /arc/arcadia
/root/yatool/ya make --checkout -j0 partner

# доступ к svn операциям для всех пользователей
chown teamcity -R /arc/arcadia/
# доступ к ya make
chown teamcity -R /.ya/
