#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../lib
  );
use qbit;
use Application;
use Term::ANSIColor qw(colored);

# global vars

$ENV{'LAZY_LOAD'} = 1;

# subs

sub show_help {

    say qq[
Скрипт для просмотра на каких ролях есть право (и на каких нет).
В качестве параметра нужно указать название права.

Пример:

    $0 bk_statistics
];

}

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    if (!@ARGV || grep {$ARGV[0] eq $_} qw(-h --help)) {
        show_help();
        exit;
    } else {

        my $right = $ARGV[0];

        say "\nНа каких ролях есть право '$right'\n";

        my $role_rights = RoleRights->new('production');
        my %has_right = $role_rights->{$right} ? %{$role_rights->{$right}} : ();

        foreach my $role (sort {$a->{id} <=> $b->{id}} @{$app->rbac->get_roles()}) {
            my $check = $has_right{$role->{id}} ? 'x' : ' ';
            $check = colored($check, 'green');
            my $internal = $role->{is_internal} ? 'внутренняя' : '';
            say sprintf '%13s %3s   %-15s %s', "[$check]", $role->{id}, $internal, $role->{name};
        }

        say '';
    }

    $app->post_run();
}
main();
__END__
