#!/usr/bin/perl -w

=encoding utf8

=head1 DESCRIPTION

Cкрипт находит день и пейджи с ненулевыми "деньгами" для каждого уровня статистики
(удобно для целей тестировния)

=head1 USAGE

 ./bin/find_pages_with_stat.pl

=cut

use strict;

use lib::abs qw(../lib);

use qbit;
use Application;

use feature 'say';
use Carp;

####
_run();
#####

sub _run {
    my $app = _get_app();

    my $stat_accessors = $app->product_manager->get_statistics_accessors();

    my $type_pages = _get_stat_data($app, $stat_accessors);

    _print_res($type_pages);

    return 1;
}

sub _get_stat_data {
    my ($app, $stat_accessors) = @_;

    my $type_pages = {
        #    'EXTERNAL | INTERNAL | DSP' => {
        #       'context | search | mobile | video | ssp' => {
        #           <DATE> => {
        #               <level> => [ {}, .. ],
        #               ...
        #           }
        #       }
        #    }
    };

    my $count = 0;
    foreach my $level (sort @$stat_accessors) {
        my $model = $app->$level;

        unless ($model->isa('Application::Model::Statistics::Hierarchy')) {
            printf qq[%02d. Level %s\n], ++$count, $level;

            my $db_table     = $model->db_table_name();
            my @table_fields = map {$_->{name}} map {@$_} $app->partner_db->$db_table->{fields};
            my $table_fields = {map {$_ => 1} @table_fields};

            my $page_field_name = eval {$model->get_page_id_field_name()};
            unless ($page_field_name) {
                ($page_field_name) = grep {$table_fields->{$_}} qw( page_id  campaign_id  dsp_id );
            }
            printf qq[    (table "%s"; field "%s")\n], $db_table, $page_field_name // 'UNKNOWN';

            die 'Unkouwn page_field_name ' . Data::Dumper->Dumper(\@table_fields) unless $page_field_name;

            my ($metric_name) = grep {$table_fields->{$_}} qw(
              partner_wo_nds
              all_w_nds
              premium_all_wo_nds
              bk_price_wo_nds
              dsp_charging_wo_nds
              );
            die 'Unkouwn metrics ' . Data::Dumper->Dumper($table_fields) unless $metric_name;

            my $one_row = $app->partner_db->$db_table->get_all(
                fields => [$page_field_name],
                filter => [$metric_name, '>', \0],
                limit  => 1,
            );

            if (@$one_row) {

                my $date = name2date('daybeforeyesterday', oformat => 'db');
                $date = date_sub($date, day => 1, iformat => 'db', oformat => 'db');

                my $data = [];
                my $order_by = [['sum_money', 1]];

                my $loop_count = 0;
                while (!@$data) {

                    my $filter = {'dt' => $date};
                    if ($date lt '2001-01-01') {
                        $filter   = undef;
                        $order_by = ['page_id'];
                    }

                    #    SELECT    dt,
                    #              campaign_id,
                    #              count(*),
                    #              sum(partner_wo_nds) as  sum_money
                    #    FROM      %s
                    #    WHERE     dt = '2017-10-11'
                    #    GROUP BY  campaign_id
                    #    HAVING    sum_money > 0
                    #    ORDER BY  sum_money desc
                    #    LIMIT    10

                    $data = $app->partner_db->$db_table->get_all(
                        fields => {
                            'page_id'   => $page_field_name,
                            'dt'        => 'dt',
                            'cnt'       => {'COUNT' => ['dt']},
                            'sum_money' => {'SUM' => [$metric_name]},
                        },
                        filter   => $filter,
                        group_by => ['page_id'],
                        having   => ['sum_money', '>', \0],
                        order_by => $order_by,
                        limit    => 10,
                    );

                    $data = [] if @$data < 5 && $date gt '2001-01-01';

                    last if $date lt '2001-01-01' && !@$data;

                    unless (@$data) {
                        $date = date_sub($date, month => 3, iformat => 'db', oformat => 'db');
                        print '    ' if $loop_count == 0;
                        print '.';
                    }
                    $loop_count++;
                }

                print "\n" if $loop_count > 1;

                if (@$data) {
                    printf qq[    %-15s %-12s %-10s  %-10s \n], $page_field_name, qw(Date  Rows), $metric_name;

                    foreach my $row (@$data) {
                        $row->{sum_money} = sprintf('%0.2f', $row->{sum_money} / 10_000_000_000);
                        $row->{sum_money} =~ s/\.?0+$//;
                        printf qq[    %-15s %-12s %-10s  %-10s \n], @$row{qw( page_id  dt  cnt  sum_money )};

                        {
                            $row->{level} = $level;

                            my ($type)     = grep {$level =~ /$_/} qw{ internal dsp  };
                            my ($sub_type) = grep {$level =~ /$_/} qw{ ssp  video  mobile context search  };

                            $type     //= 'external';
                            $sub_type //= 'undef';

                            push @{$type_pages->{$type}->{$sub_type}->{$row->{dt}}->{$level}}, $row;
                        }
                    }
                }
            }

            printf qq[    Table is EMPTY!!\n] unless @$one_row;

            say "";
        }
    }

    return $type_pages;
}

sub _print_res {
    my ($type_pages) = @_;

    say 'Pages:';
    foreach my $type (sort keys %$type_pages) {
        say ' ' x 2, uc $type;
        foreach my $sub_type (sort keys %{$type_pages->{$type}}) {
            say ' ' x 4, $sub_type;

            my $dt_data = $type_pages->{$type}->{$sub_type};

            my $date_pages = {};
            {
                my @dates_sotred =
                  sort {scalar(keys %{$dt_data->{$b}}) <=> scalar(keys %{$dt_data->{$a}})} keys %$dt_data;

                my $level_data   = {};
                my $multi_levels = {};
                my @date_groups  = ();
                foreach my $dt (@dates_sotred) {
                    my @levels = grep {!$multi_levels->{$_}} keys %{$dt_data->{$dt}};
                    if (scalar(@levels) > 1) {
                        map {$multi_levels->{$_} = 1} $multi_levels;
                        push @date_groups, map {$dt_data->{$dt}->{$_}} @levels;
                    } else {
                        my $level = $levels[0];
                        push @{$level_data->{$level}}, @{$dt_data->{$dt}->{$level}};
                        delete $dt_data->{$dt};
                    }
                }
                push @date_groups, map {$level_data->{$_}} keys %$level_data;

                my $dates_data = {};
                foreach my $rows (@date_groups) {
                    my $chosen_row = undef;
                    {
                        my @cnt_orderd = sort {$b->{cnt} <=> $a->{cnt}} @$rows;
                        foreach my $row (@cnt_orderd) {
                            if ($row->{cnt} <= 1000) {
                                $chosen_row = $row;
                                last;
                            }
                        }
                        $chosen_row //= $cnt_orderd[0];
                    }
                    push @{$date_pages->{$chosen_row->{dt}}}, $chosen_row;
                }

            }

            foreach my $dt (reverse sort keys %$date_pages) {
                say ' ' x 6, $dt, " - ", join(",", sort {$a <=> $b} map {$_->{page_id}} @{$date_pages->{$dt}});
            }
        }
    }

    return 1;
}

sub _get_app {

    my $app;
    {
        $app = Application->new();
        $app->pre_run();

        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    return $app;
}
