#!/bin/bash -e

BLUE='\033[0;34m'
RED='\033[0;31m'
NC='\033[0m' # No Color

rm -rf java-dbschema/ && mkdir java-dbschema/
make -s partner_db_create_sql_show | perl -MFile::Slurp -e 'for my $s (split /;\s*\n/, join "", <>) {if ($s =~ /CREATE TABLE IF NOT EXISTS `(\w+)`/s) {write_file "java-dbschema/$1.schema.sql", $s} elsif ($s =~ /CREATE OR REPLACE.*VIEW `(\w+)`/s) {write_file "java-dbschema/$1.view.sql", $s}}'
echo "insert into all_pages select * from all_pages_view" > java-dbschema/all_pages.postprocess.sql
ls mocked_databases_restapi/partner_db/*.sql | perl -lne 'system(cp => $_, s#.*/(.*).sql#java-dbschema/$1.data.sql#r)'
ls MySQL/partner_db/*.sql | perl -lne 'system(cp => $_, s#.*/(.*).sql#java-dbschema/$1.trigger.sql#r)'
rm -f ./mocked_databases_restapi/*.sql
TAP_VERSION=1 JAVA_MOCKED_JSONAPI_URL='' perl -I./lib -I./t_lib -I./t/lib -I./local/lib/perl5/ ./bin/update_all_blocks_pages.pl all_blocks
printf "${BLUE}EXECUTE ON YOUR LAPTOP IN ROOT OF JAVA PROJECT:${NC}\n"
echo "  > rsync -vaP --delete `hostname -f`:`pwd`/java-dbschema/ java/libs/dbschema/src/main/resources/partner/"
printf "  > ./java/dbschemagen/update_jooq.sh\n\n"
