#!/bin/bash

# узнаем локальный туннель до продакшена
# если нет такого - создаем


export DST="$1"
export HOST_LOCAL="localhost"
export PORT_LOCAL=8101
export HOST_PROXY="pi-rtb01f.yandex.ru"

DST=$(echo $DST | egrep '^[a-z].*:[0-9][0-9]*$')

if [ -z "$DST" ]; then
    echo -e "Usage:\n  1. raw: $0 balance-xmlrpc.yandex.net:8002\n  2. in bash: curl https://\$($0 balance-xmlrpc.yandex.net:8002)/...\n  3. app cfg: ... url => \"http://\".\`./bin/get_proxy.sh balance-xmlrpc.yandex.net:8002\`.\"/xmlrpc\";,"
    exit 1
fi

FOUND=$(ps -o 'pid,ppid,cmd' --ppid 1 | grep ssh | perl -ne '/-L\s+('$HOST_LOCAL':)?(\d+):'$DST'\b/ && print "'$HOST_LOCAL':$2\n"' | head -1)

if [ -z "$FOUND" ]; then
    # create a new tunnel
    PORT_FREE=$(seq $PORT_LOCAL $(($PORT_LOCAL+1000)) | xargs -i{} -n 1 echo "$HOST_LOCAL:{}" | grep -v -f <(netstat -l | grep -o $HOST_LOCAL':[0-9][0-9]*') | head -1)
    ssh -f -N -L $PORT_FREE:$DST $HOST_PROXY
    $0 $*
else
    # show tunnel found
    echo -n $FOUND;
    test -t 1 && echo -ne "\n"
fi
