#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);
use Getopt::Long qw();
# global vars

# subs
sub _get_args {
    my ($stat_accessors, $cron_stat_accessors) = @_;

    my $increase_version = '';
    my $msg              = '';

    Getopt::Long::GetOptions(
        'increase_version' => \$increase_version,
        'msg'              => \$msg,
    );

    return ($msg, $increase_version);
}
# main
sub main {

    my ($msg, $increase_version) = _get_args();

    my $tag_prefix     = 'tags/releases/partner/perl/';
    my $version_prefix = "2\\.18\\.";
    my $latest_version =
`arc fetch $tag_prefix && arc tag -l | grep ^$tag_prefix$version_prefix |grep -o '$version_prefix\[0-9]*\' | sort -V | tail -1`;
    chomp $latest_version;

    $latest_version =~ /$version_prefix([0-9]+)/;
    my $new_version = '2.18.' . ($1 + ($increase_version ? 1 : 0));

    if ($msg) {
        say "Version $new_version";
    } else {
        say $new_version;
    }
}
main();
__END__
