#!/bin/bash

PROXY_ADDR=$1
PROXY_PORT=$2
SERVER_ADDR=$3
SERVER_PORT=$4
TARGET_STAGE=$5

MYSQL_CREDENTIALS_PATH="/mysql_credentials.env"
PI_SECRETS_PATH="/etc/pi-secrets.json"
DATABASE_CONFIG_PATH="/usr/share/partners/lib/DatabaseConfig.json"

if [[ -f $MYSQL_CREDENTIALS_PATH ]]; then
    # Этот код работает в облаке: Qloud и Deploy
    source /mysql_credentials.env
elif [[ -f $PI_SECRETS_PATH ]]; then
    EXECUTION_STAGE=`cat /etc/yandex/environment.type`
    # Этот код работает только на железных машинках
    if [[ $EXECUTION_STAGE == "development" ]]; then
        # На деве стоит прокся во все инстансы БД: dev/test/prod.
        # Поэтому нужно еще понимать, куда идет запрос, и подбирать соответствующий логин+пароль.
        USER_FILE_PATH=$PI_SECRETS_PATH
        if [[ $TARGET_STAGE == "production" ]]; then
            USER_JSON_PATH='.["connection-to-partner2-prod-database"]["user"]'
            PASSWORD_JSON_PATH='.["connection-to-partner2-prod-database"]["password"]'
        elif [[ $TARGET_STAGE == "testing" ]]; then
            USER_JSON_PATH='.["connection-to-partner2-testing-database"]["user"]'
            PASSWORD_JSON_PATH='.["connection-to-partner2-testing-database"]["password"]'
        elif [[ $TARGET_STAGE == "development" ]]; then
            USER_JSON_PATH='.["connection-to-partner2-development-database"]["user"]'
            PASSWORD_JSON_PATH='.["connection-to-partner2-development-database"]["password"]'
        else
            echo "Unexpected target stage: $TARGET_STAGE"
            exit 1
        fi
    elif [[ $EXECUTION_STAGE == "testing" || $EXECUTION_STAGE == "production" ]]; then
        USER_FILE_PATH=$DATABASE_CONFIG_PATH
        USER_JSON_PATH=".partnerdb2.user"
        PASSWORD_JSON_PATH='.["partner2-mysql-password"]'
    else
        echo "Unexpected execution stage: $EXECUTION_STAGE"
        exit 1
    fi
    MYSQL_USER=`cat $USER_FILE_PATH | jq -r "$USER_JSON_PATH"`
    MYSQL_PASSWORD=`cat $PI_SECRETS_PATH | jq -r "$PASSWORD_JSON_PATH"`
else
    echo "Failed to find file with mysql credentials"
    exit 1
fi

RESULT=$(/usr/bin/mysql --host=$SERVER_ADDR --port=$SERVER_PORT --user=$MYSQL_USER --password=$MYSQL_PASSWORD -e "SHOW SLAVE STATUS" 2>/dev/null)

if [[ $? -eq 0 && -z "$RESULT" ]]
then
    exit 0
else
    exit 1
fi
