#!/usr/bin/python3

import argparse
import subprocess
import os

parser = argparse.ArgumentParser()
parser.add_argument('beta_port')
parser.add_argument('login')
parser.add_argument('filter', nargs='?', default='')
parser.add_argument('-r', '--route', nargs='?', default='', help='Route')

args = parser.parse_args()

dir = os.path.dirname(os.path.realpath(__file__))

def fields(path: str) -> str:
    with open(dir + path) as f:
        return ','.join(f.read().splitlines())

subprocess.run([
    'perl', dir + '/../PI-22689_api_diff.pl',
    '--accessor', 'internal_mobile_app_rtb',
    '--beta_port', args.beta_port,
    '--login', args.login,
    '--route', args.route,
    '--token', open(os.path.expanduser('~/.jsonapi_token')).readline().rstrip('\n'),
    '--ignore_editable_fields', fields('/ignore_req_fields.txt'),
    '--ignore_available_fields', 'same_as_editable',
    '--ignore_req_fields', fields('/ignore_req_fields.txt'),
    '--ignore_add_fields', fields('/ignore_req_fields.txt'),
    '--filter', args.filter
])
