#!/bin/bash

while [ -n "$1" ]; do
  case "$1" in
  -h) echo "available options:
   -o <file> redirect java logging to file
   -h help
   available params:
   --validator run java in validator mode with params
      --pageIds=1037,1038,..  - pages to validate
        OR
      --filePath=<file> - file with page to validate
      --split=3 - number of java threads(optional)
   --api run JsonAPI server
   EXAMPLE: ./java_start.sh -o ~/log.txt -- --validator pageIds=1037
   <DIR> <JAVA_APP> <PORT> <PID> standart run of java app"
    exit 0;;
  -o)
    LOG_FILE=$2
    echo "log will be redirected to file $2"
    shift
    ;;
  --pid_file)
    PID_FILE=$2
    echo "the pid file will be $2"
    shift
    ;;
  --port)
    PORT=$2
    echo "the port will be $2"
    shift
    ;;
  --)
    shift
    break
    ;;
  *) break ;;
  esac
  shift
done

if [[ "$1" == '--validator' ]]; then
  echo "java started as runner validator"
  WORK_DIR='./'
  LAYER='runner'
  PORT=0
  PID_FILE=${PID_FILE:-$WORK_DIR${LAYER}.pid}
  PROFILE=oneshot,validation
  LOG_LEVEL=WARN
  EXTRAARGS=${@:2}
elif [[ "$1" == '--api' ]]; then
  echo "java started as JsonAPI server"
  WORK_DIR='./'
  LAYER='jsonapi'
  PROFILE=test
  PID_FILE=${PID_FILE:-$WORK_DIR${LAYER}.pid}
  JAVA_OPTS=-Dlogging.config=classpath:logback-dev.xml
else
  WORK_DIR=$1
  LAYER=$2
  PORT=$3
  PID_FILE=$4
fi

export PATH_TO_VERSION=$WORK_DIR

export API_KEY_TOKEN=$(jq  -r '.["apikey-token"]' /etc/pi-secrets.json)
export DEPLOY_TVM_TOOL_URL=http://localhost:18080
export TVMTOOL_LOCAL_AUTHTOKEN=$(cat "$(jq -r '.api_tvm.auth_token_path' $WORK_DIR/lib/Application.json)")

export MYSQL_HOST=$(jq -r '.partnerdb2.host' $WORK_DIR/lib/DatabaseConfig.json)
export MYSQL_PORT=$(jq -r '.partnerdb2.port' $WORK_DIR/lib/DatabaseConfig.json)

export MYSQL_USER=$(jq -r '.partnerdb2.user' $WORK_DIR/lib/DatabaseConfig.json)
export MYSQL_PASSWORD=$(jq -r '.partnerdb2.password' $WORK_DIR/lib/DatabaseConfig.json)
export SECRET_YT_TOKEN=$(jq '.["yt-token"]' -r /etc/pi-secrets.json)
export JUGGLER_OAUTH_TOKEN=$(jq '.["juggler-token"]' -r /etc/pi-secrets.json)
export SECRET_YQL_TOKEN=$(jq -r .[\"yql-token\"] /etc/pi-secrets.json)
export SECRET_PARTNER2_CLICKHOUSE_USER=$(jq -r .[\"partner2-clickhouse-user\"] /etc/pi-secrets.json)
export SECRET_PARTNER2_CLICKHOUSE_PASSWORD=$(jq -r .[\"partner2-clickhouse-password\"] /etc/pi-secrets.json)

export ${LAYER^^}_PROFILE=${PROFILE:-dev}
export ${LAYER^^}_SERVER_PORT=$PORT
export ${LAYER^^}_MANAGEMENT_PORT=$((100+$PORT))
export ${LAYER^^}_PID_FILE=$PID_FILE
export ${LAYER^^}_LOG_FILE=${LOG_FILE:-$WORK_DIR/nginx/java-$LAYER.log}
export ${LAYER^^}_LOG_LEVEL=${LOG_LEVEL:-INFO}
export JAVA_OPTS=$JAVA_OPTS

$WORK_DIR/java/$LAYER/app/java/$LAYER/bin/yandex-partner-java-$LAYER.sh "$WORK_DIR/java/$LAYER/app/java/$LAYER" $EXTRAARGS
