#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

=head1 SYNOPSIS

./bin/mds_s3_client.pl --method=list

./bin/mds_s3_client.pl --method=get --key=file_to_get.txt --file=where_to_save.txt

./bin/mds_s3_client.pl --method=put --key=name_in_s3.txt --file=/home/username/file_to_send.txt

./bin/mds_s3_client.pl --method=delete --key=no_longer_needed.txt

=cut

use lib::abs qw(../lib);

use qbit;

use Application;

use Getopt::Long;
use Pod::Usage;
use Data::Dumper;

sub main {
    my %args;
    GetOptions(\%args, 'help|h|?', 'method=s', 'key=s', 'file=s', 'scalar=s', 'prefix=s', 'type=s',) or pod2usage(1);

    pod2usage(1) if $args{help};

    my $app = Application->new();

    $app->pre_run();

    my @method_args = _validate_args(%args);

    my $method       = $args{method};
    my $return_value = $app->api_media_storage_s3->$method(@method_args);
    print Dumper($return_value);
}
main();

sub _validate_args {
    my (%args) = @_;

    die 'Option method is required' unless defined $args{method};

    $args{prefix} //= '';

    my %args_by_method = (
        list     => ['prefix'],
        get      => ['key'],
        delete   => ['key'],
        get_file => ['key', 'file'],
        put_file => ['key', 'type', 'file'],
        put      => ['key', 'type', 'scalar'],
    );

    for my $arg_name (@{$args_by_method{$args{method}}}) {
        die "Option $arg_name is required for method $args{method}"
          unless defined $args{$arg_name};
    }

    return @args{@{$args_by_method{$args{method}}}};
}
