#!/usr/bin/perl

use lib::abs qw(
  ../lib
  ../local/lib/perl5
  );
use Pod::Usage;

use qbit;
use Utils::ScriptWrapper 'util';

sub prepare_args {
    my ($opts) = @_;

    foreach my $arg (qw(models set unset)) {
        if ($opts->{$arg}) {
            $opts->{$arg} = {map {$_ => 1,} split /\s*,\s*/, join ',', @{$opts->{$arg}}};
        }
    }
    $opts->{models} = {map {$_ => 1,} qw(page block)} unless ($opts->{models} && scalar keys %{$opts->{models}});
    $opts->{limit} //= 100000;

    die "set or unset option should be specified" unless ($opts->{set} || $opts->{unset});
}

sub args {
    my ($opts) = @_;

    return (
        'models=s@' => \$opts->{models},
        'set=s@'    => \$opts->{set},
        'unset=s@'  => \$opts->{unset},
        'limit=i'   => \$opts->{limit},
    );
}

run(
    sub {
        my ($app, $opts) = @_;

        if (delete($opts->{models}{page}) || delete($opts->{models}{pages})) {
            $opts->{models}{$_} = 1 foreach @{$app->product_manager->get_page_model_accessors()};
        }
        if (delete($opts->{models}{block}) || delete($opts->{models}{blocks})) {
            $opts->{models}{$_} = 1 foreach @{$app->product_manager->get_block_model_accessors()};
        }

        print "-- SQL start\n";
        if ($opts->{set}) {
            print join "\n",
              'DELIMITER $$',
              'CREATE PROCEDURE SetMultistate()',
              'BEGIN',
              '    DECLARE counter INT DEFAULT 0;',
              '    DECLARE iteration INT DEFAULT 0;',
              '';
            foreach my $state (sort keys %{$opts->{set}}) {
                foreach my $model_name (sort keys %{$opts->{models}}) {
                    my $model      = $app->$model_name;
                    my $multistate = $model->get_multistate_by_name($state);
                    my $query =
                      sprintf 'UPDATE `%s` SET `multistate` = `multistate` | %d WHERE NOT `multistate` & %d LIMIT %d;',
                      $model->db_table_name(), $multistate, $multistate, $opts->{limit};
                    print join "\n",
                      '    SET iteration = 1;',
                      '    REPEAT',
                      sprintf('        SELECT CONCAT("%s, iteration: ", iteration) AS debug;', $model_name),
                      '        ' . $query,
                      '        SET iteration = iteration + 1;',
                      '        SET counter = ROW_COUNT();',
                      '    UNTIL counter = 0',
                      '    END REPEAT;',
                      '';
                }
            }
            print join "\n", 'END$$', 'DELIMITER ;', 'CALL SetMultistate();', 'DROP PROCEDURE SetMultistate;', '';
        }

        if ($opts->{unset}) {
            print join "\n",
              'DELIMITER $$',
              'CREATE PROCEDURE UnsetMultistate()',
              'BEGIN',
              '    DECLARE counter INT DEFAULT 0;',
              '    DECLARE iteration INT DEFAULT 0;',
              '';
            foreach my $state (sort keys %{$opts->{unset} // {}}) {
                foreach my $model_name (sort keys %{$opts->{models}}) {
                    my $model      = $app->$model_name;
                    my $multistate = $model->get_multistate_by_name($state);
                    my $query =
                      sprintf 'UPDATE `%s` SET `multistate` = `multistate` & ~%d WHERE `multistate` & %d LIMIT %d;',
                      $model->db_table_name(), $multistate, $multistate, $opts->{limit};
                    print join "\n",
                      '    SET iteration = 1;',
                      '    REPEAT',
                      sprintf('        SELECT CONCAT("%s, iteration: ", iteration) AS debug;', $model_name),
                      '        ' . $query,
                      '        SET iteration = iteration + 1;',
                      '        SET counter = ROW_COUNT();',
                      '    UNTIL counter = 0',
                      '    END REPEAT;',
                      '';
                }
            }
            print join "\n", 'END$$', 'DELIMITER ;', 'CALL UnsetMultistate();', 'DROP PROCEDURE UnsetMultistate;', '';
        }
        print "-- SQL end\n";
    }
   );
