package GMFixBkData;

use qbit;

use GMUtils;
use PiConstants qw(
  $NATURAL_BLOCK_TRANSPORT_TYPE
  );

use base qw(Exporter);
our @EXPORT_OK = qw(
  fix_bk_data
  );

sub fix_bk_data {
    my ($row) = @_;

    my $bkdata = clone($row->{bk_data_custom});

    delete_UnExistsDSP($bkdata);
    delete_PartnerShare($bkdata);
    set_OPTB($row->{model}, $bkdata);
    set_PICategories($bkdata);
    delete_UnExistsBrands($bkdata);
    fix_AdvPosition($bkdata);
    delete_AdTypeOverAdTypeSet($bkdata);

    fix_NaturalBlock($bkdata) if $row->{model} =~ /_natural$/;
    fix_ContentBlock($bkdata) if $row->{model} =~ /_content$/;

    return $bkdata;
}

sub delete_PartnerShare {
    my ($bkdata) = @_;

    if ($bkdata->{DSPInfo}) {
        for my $i (@{$bkdata->{DSPInfo}}) {
            delete $i->{PartnerShare};
        }
    }
}

sub delete_UnExistsDSP {
    my ($bkdata) = @_;

    if ($bkdata->{DSPInfo}) {
        my $app = get_app();
        my @data;
        for my $i (@{$bkdata->{DSPInfo}}) {
            push @data, $i if check_dsp_exists($app, $i->{DSPID});
        }
        $bkdata->{DSPInfo} = \@data;
    }
}

sub set_OPTB {
    my ($model, $bkdata) = @_;

    if ($model =~ /context_on_site_rtb$/
        and not exists $bkdata->{'CustomBlockData'}{'only-portal-trusted-banners'})
    {
        $bkdata->{'CustomBlockData'}{'only-portal-trusted-banners'} = 0;
    }
}

sub set_PICategories {
    my ($bkdata) = @_;

    unless (exists $bkdata->{PICategoryIAB}) {
        $bkdata->{PICategoryIAB} = {};
    }
}

sub delete_UnExistsBrands {
    my ($bkdata) = @_;

    if ($bkdata->{Brand}) {
        my $app = get_app();
        $bkdata->{Brand} = filter_brand_exists($app, $bkdata->{Brand});
    }
}

sub fix_AdvPosition {
    my ($bkdata) = @_;

    # if (
    #     exists $bkdata->{CustomBlockData}
    #         and exists $bkdata->{CustomBlockData}{WidgetInfo}
    # ) {
    #     my $wi = $bkdata->{CustomBlockData}{WidgetInfo};
    #     if (exists $wi->{AdvPosition} and ref $wi->{AdvPosition}) {
    #         $wi->{AdvPosition} = $wi->{Height} * $wi->{Width};
    #     }
    # }
}

sub _fix_WidgetInfo {
    my ($bkdata, $valid) = @_;

    my $wi = $bkdata->{CustomBlockData}{WidgetInfo} //= {};
    delete @{$wi}{grep {!$valid->{$_}} keys %$wi};

    return $wi;
}

my %valid_Natural = map {$_ => 1} qw(Type CSS Template Height Width);

sub fix_NaturalBlock {
    my ($bkdata) = @_;

    my $wi = _fix_WidgetInfo($bkdata, \%valid_Natural);

    $wi->{Type} = $NATURAL_BLOCK_TRANSPORT_TYPE;

    #PI-13940 default values
    $bkdata->{Width}       = 970;
    $bkdata->{Height}      = 250;
    $bkdata->{DirectLimit} = 1;
    $bkdata->{Sizes}       = [
        {
            "Height" => 0,
            "Width"  => 0
        }
    ];
}

my %valid_Content = (
    new => {
        %valid_Natural,
        NewsJsonOptionId => 1,
        NeedPictures     => 1,
        AdvPosition      => 1,
        NewsParams       => 1,
    },
    old => {
        %valid_Natural,
        Sources     => 1,
        AdvPosition => 1,
    }
);

sub fix_ContentBlock {
    my ($bkdata) = @_;

    my $wi = _fix_WidgetInfo($bkdata, $valid_Content{$bkdata->{CustomBlockData}{WidgetInfo}{Sources} ? 'old' : 'new'});

}

# удаляем лимиты на заблокированые продукты
sub delete_AdTypeOverAdTypeSet {
    my ($bkdata) = @_;

    return unless $bkdata->{AdTypeSet} and $bkdata->{AdType};

    for my $product (keys %{$bkdata->{AdTypeSet}}) {
        unless ($bkdata->{AdTypeSet}{$product}) {
            delete $bkdata->{AdType}{$product};
        }
    }
}

1;
