package GMFixBlockData;

use qbit;
use PiConstants qw(
  $MAX_CPM $CPM_MULTIPLIER $BLOCKED_CPM_VALUE
  $MIN_CPM_STRATEGY_ID
  $MAX_REVENUE_STRATEGY_ID
  $YAN_TRAFFIC_STRATEGY_ID
  $SEPARATE_CPM_STRATEGY_ID
  );

use GMUtils;

use base qw(Exporter);
our @EXPORT_OK = qw(
  fix_block_data
  );

sub fix_block_data {
    my ($row) = @_;

    my $app      = get_app();
    my $accessor = $row->{model};
    my $model    = $app->$accessor;

    #обновление независимых связанных таблиц
    update_brands($app, $row);
    update_thematics($app, $row);
    update_dsp($app, $row);

    # обновление данных на блоке
    my %update_table;
    my %update_opts;
    update_OptimizeType($app, $accessor, $row, \%update_table, \%update_opts);
    update_AlternativeCode($app, $accessor, $row, \%update_table, \%update_opts);
    update_BlindLevel($app, $accessor, $row, \%update_table, \%update_opts);
    update_SiteVersion($app, $accessor, $row, \%update_table, \%update_opts);
    update_RtbDesign($app, $accessor, $row, \%update_table, \%update_opts);
    update_PremiumVideoFormat($app, $accessor, $row, \%update_table, \%update_opts);
    update_CustomBlockData($app, $accessor, $row, \%update_table, \%update_opts);
    update_MediaBlock($app, $accessor, $row, \%update_table, \%update_opts) if $accessor =~ /context_on_site_rtb$/;
    update_DirectBlock($app, $accessor, $row, \%update_table, \%update_opts) if $accessor =~ /mobile_app_rtb$/;

    update_FormFactor($app, $accessor, $row, \%update_table, \%update_opts) if $accessor =~ /context_on_site_rtb$/;

    # сохранение данных
    $update_table{is_custom_bk_data} = 0;
    if (%update_opts) {
        my $orig = $app->partner_db->$accessor->get([$row->{page_id}, $row->{id}], fields => ['opts']);
        my %tmp = %{from_json($orig->{opts})};
        @tmp{keys %update_opts} = values %update_opts;
        for my $k (keys %tmp) {
            delete $tmp{$k} unless defined $tmp{$k};
        }
        $update_table{opts} = to_json(\%tmp);
        # ldump($update_table{opts});
    }
    $app->partner_db->$accessor->edit([$row->{page_id}, $row->{id}], \%update_table);

    my $block = $model->get($row->{public_id}, fields => ['*']);
    my $bk_data = $model->get_bk_block_data($block);
    if ($bk_data) {
        $bk_data->{BlockModel} = $accessor;
        if (exists($bk_data->{'PageImpOptions'})) {
            map {$bk_data->{'PageImpOptions'}{$_} = [] if !exists($bk_data->{'PageImpOptions'}{$_})} qw(Enable Disable);
        }
    }

    my @db_fields = keys %{get_real_db_fields($app, $accessor)};
    my %table_data;
    @table_data{@db_fields} = @{$block}{@db_fields};
    delete $table_data{bk_data};

    return ($bk_data, \%table_data);
}

sub update_brands {
    my ($app, $row) = @_;

    my $brands = $row->{bk_data_custom}{Brand} // {};
    my @data;
    for my $bid (keys %$brands) {
        my %d = (
            page_id  => $row->{page_id},
            block_id => $row->{id},
            bid      => $bid,
            cpm      => undef,
            blocked  => 1,
        );
        my $value = $brands->{$bid}{value};
        unless ($value == $BLOCKED_CPM_VALUE
            or ($value = int($value / $CPM_MULTIPLIER)) >= $MAX_CPM)
        {
            $d{cpm}     = $value;
            $d{blocked} = 0;
        }
        push @data, \%d;
    }
    my $filtred = filter_brand_exists($app, \@data);

    my $filter = $app->partner_db->filter({page_id => $row->{page_id}, block_id => $row->{id}});
    $app->partner_db->brands->delete($filter);
    $app->partner_db->brands->add_multi($filtred) if @$filtred;
}

sub update_thematics {
    my ($app, $row) = @_;
    update_tns_thematics($app, $row);
    update_iab_thematics($app, $row);
}

sub update_tns_thematics {
    my ($app, $row) = @_;

    my $tns = $row->{bk_data_custom}{Article};
    my @data;
    for my $cid (keys %$tns) {
        my %d = (
            page_id     => $row->{page_id},
            block_id    => $row->{id},
            article_sid => $cid,
            cpm         => $MAX_CPM,
        );
        my $value = $tns->{$cid}{value};
        unless ($value == $BLOCKED_CPM_VALUE
            or ($value = int($value / $CPM_MULTIPLIER)) >= $MAX_CPM)
        {
            $d{cpm} = $value;
        }
        push @data, \%d;
    }
    my $filter = $app->partner_db->filter({page_id => $row->{page_id}, block_id => $row->{id}});
    $app->partner_db->articles->delete($filter);
    $app->partner_db->articles->add_multi(\@data) if @data;
}

sub update_iab_thematics {
    my ($app, $row) = @_;

    my $iab = $row->{bk_data_custom}{PICategoryIAB};
    unless ($iab) {
        return;
    }

    my %niab;
    for my $e (keys %$iab) {
        my @values = values %{$iab->{$e}};
        $niab{$e} = $values[0];
    }

    my @data;
    for my $c (keys %niab) {
        my %d = (
            page_id     => $row->{page_id},
            block_id    => $row->{id},
            category_id => $c,
            cpm         => $MAX_CPM,
        );
        my $value = $niab{$c};
        unless ($value == $BLOCKED_CPM_VALUE
            or ($value = int($value / $CPM_MULTIPLIER)) >= $MAX_CPM)
        {
            $d{cpm} = $value;
        }
        push @data, \%d;
    }

    my $filter = $app->partner_db->filter({page_id => $row->{page_id}, block_id => $row->{id}});
    $app->partner_db->picategories->delete($filter);
    $app->partner_db->picategories->add_multi(\@data) if @data;
}

sub update_OptimizeType {
    my ($app, $accessor, $row, $update, $opts) = @_;

    my $sm;
    if ($app->$accessor->can('storage_method_of_strategies')) {
        $sm = $app->$accessor->storage_method_of_strategies eq 'opts';
    }

    return unless $app->$accessor->can('get_strategies');
    my $st           = $app->$accessor->get_strategies;
    my $OptimizeType = $row->{bk_data_custom}{OptimizeType};

    return unless %$st and defined $OptimizeType;
    my $adtypeset = $row->{bk_data_custom}{AdTypeSet};
    my $adtype    = $row->{bk_data_custom}{AdType};
    if (    $accessor =~ /context_on_site_rtb$/
        and $st->{$SEPARATE_CPM_STRATEGY_ID}
        and ($OptimizeType == $MIN_CPM_STRATEGY_ID or $OptimizeType == $MAX_REVENUE_STRATEGY_ID))
    {
        unless ($adtypeset->{media} and $adtypeset->{'media-performance'}) {
            $OptimizeType = $SEPARATE_CPM_STRATEGY_ID;
        } elsif ($adtype and %$adtype) {
            $OptimizeType = $SEPARATE_CPM_STRATEGY_ID;
        }
    }

    my %data = (strategy => $OptimizeType);
    for my $k (keys %$st) {
        if (exists $st->{$k}{fields}) {
            for my $f (@{$st->{$k}{fields}}) {
                @data{($f . '_active', $f . '_blocked', $f . '_cpm')} = (0, undef, undef);
            }
        }
    }
    unless ($adtypeset->{video}) {
        $data{show_video} = 0 if get_real_db_fields($app, $accessor)->{show_video};
    }

    if ($OptimizeType == $MIN_CPM_STRATEGY_ID) {
        my $min_cpm = $MAX_CPM * $CPM_MULTIPLIER;
        for my $dsp (@{$row->{bk_data_custom}{DSPInfo}}) {
            if ($min_cpm > $dsp->{CPM}) {
                $min_cpm = $dsp->{CPM};
            }
        }
        $data{mincpm} = int($min_cpm / $CPM_MULTIPLIER);
    }

    if ($OptimizeType == $YAN_TRAFFIC_STRATEGY_ID) {
        $data{percent_traffic} = 100 - $row->{bk_data_custom}{AlternativeTraffPart} // 0;
    }

    if ($OptimizeType == $SEPARATE_CPM_STRATEGY_ID) {
        unless ($adtypeset->{media} and $adtypeset->{'media-performance'}) {
            $data{media_active}  = 1;
            $data{media_blocked} = 1;
            $data{text_active}   = 0;
        }
        if ($adtype and %$adtype) {
            if ($adtype->{media} and $adtypeset->{media}) {
                $data{media_active}  = 1;
                $data{media_blocked} = 0;
                $data{media_cpm}     = int($adtype->{media}{value} / $CPM_MULTIPLIER);
            }
            if ($adtype->{text} and $adtypeset->{text}) {
                $data{text_active}  = 1;
                $data{text_blocked} = 0;
                $data{text_cpm}     = int($adtype->{text}{value} / $CPM_MULTIPLIER);
            }
            if ($adtype->{video} and $adtypeset->{video}) {
                $data{video_active}  = 1;
                $data{video_blocked} = 0;
                $data{video_cpm}     = int($adtype->{video}{value} / $CPM_MULTIPLIER);
            }
        }
        if ($app->$accessor->can('get_non_applicable_seperate_cpm_strategy_fields')
            and my @r = $app->$accessor->get_non_applicable_seperate_cpm_strategy_fields($row))
        {
            @data{@r} = ();
        }
    }

    if ($sm) {
        @{$opts}{keys %data} = values %data;
    } else {
        @{$update}{keys %data} = values %data;
    }
}

sub update_AlternativeCode {
    my ($app, $accessor, $row, $update) = @_;

    return unless get_real_db_fields($app, $accessor)->{alternative_code};

    my %data = (alternative_code => $row->{bk_data_custom}{AlternativeCode},);
    @{$update}{keys %data} = values %data;
}

sub update_AlternativeSize {
    my ($app, $accessor, $row, $update) = @_;

    return unless get_real_db_fields($app, $accessor)->{alternative_width};

    my %data = (
        alt_width  => $row->{bk_data_custom}{AltWidth},
        alt_height => $row->{bk_data_custom}{AltHeight},
    );
    @{$update}{keys %data} = values %data;
}

sub update_BlindLevel {
    my ($app, $accessor, $row, $update) = @_;

    return unless get_real_db_fields($app, $accessor)->{blind};

    my %data = (blind => $row->{bk_data_custom}{BlindLevel},);
    @{$update}{keys %data} = values %data;
}

sub update_dsp {
    my ($app, $row) = @_;

    my $dsps = $row->{bk_data_custom}{DSPInfo} // [];
    my @data;
    my %has;
    for my $dsp (@$dsps) {
        next if $has{$dsp->{DSPID}};
        $has{$dsp->{DSPID}} = 1;
        next unless check_dsp_exists($app, $dsp->{DSPID});
        my %d = (
            page_id  => $row->{page_id},
            block_id => $row->{id},
            dsp_id   => $dsp->{DSPID},
        );
        push @data, \%d;
    }

    my $filter = $app->partner_db->filter({page_id => $row->{page_id}, block_id => $row->{id}});
    $app->partner_db->block_dsps->delete($filter);
    $app->partner_db->block_dsps->add_multi(\@data) if @data;
}

sub update_SiteVersion {
    my ($app, $accessor, $row, $update) = @_;

    return unless get_real_db_fields($app, $accessor)->{site_version};
    my $enable = $row->{bk_data_custom}{PageImpOptions}{Enable};
    my $sv     = $app->$accessor->get_site_versions;
    for my $v (@$enable) {
        if ($sv->{$v}) {
            $update->{site_version} = $v;
            last;
        }
    }
}

sub update_RtbDesign {
    my ($app, $accessor, $row, $update) = @_;

    return unless $accessor =~ /_rtb$/;
    my $designs = $row->{bk_data_custom}{RtbDesign};
    my %update;
    my %has;
    for my $k (keys %$designs) {
        next if $has{$k};
        $has{$k} = 1;

        if ($k == 0) {
            $update->{horizontal_align} = $designs->{$k}{design}{horizontalAlign} ? 1 : 0;
            next;
        }
        my %tmp = %{$designs->{$k}{design}};
        delete $tmp{blockId};

        # переименование формата
        $tmp{name} = format_mapping($tmp{name}) if defined $tmp{name};

        # приведом к числу
        for my $fix (qw(limit width height fullscreenDuration fontSize imageHeight imageWidth advSpacing)) {
            next unless exists $tmp{$fix} and defined $tmp{$fix} and $tmp{$fix} =~ /^[\d\.]+$/;
            $tmp{$fix} = 0 + $tmp{$fix};
        }

        # приведом к json
        for my $fix (qw(borderRadius)) {
            next unless exists $tmp{$fix} and defined $tmp{$fix};
            if ($tmp{$fix} eq "true") {
                $tmp{$fix} = JSON::XS::true;
            } elsif ($tmp{$fix} eq "false") {
                $tmp{$fix} = JSON::XS::false;
            } else {
                delete $tmp{$fix};
            }
        }

        # приведом к json
        for my $fix (qw(fullscreen interscroller horizontalAlign)) {
            next unless exists $tmp{$fix} and defined $tmp{$fix};
            $tmp{$fix} = $tmp{$fix} ? JSON::XS::true : JSON::XS::false;
        }

        # приведом Color к верхнему регистру
        for my $fix (keys %tmp) {
            next unless $fix =~ /Color$/;
            next unless defined $tmp{$fix};
            $tmp{$fix} = normalize_color($tmp{$fix});
        }

        # удаляем ненужные зависимые поля
        if (exists $tmp{borderType} and defined $tmp{borderType} and $tmp{borderType} eq 'none') {
            delete $tmp{borderRadius};
            delete $tmp{borderColor};
        }

        for my $k (keys %tmp) {
            delete $tmp{$k} unless defined $tmp{$k};
        }

        $update{$k} = to_json(\%tmp);
    }

    $app->partner_db->_do(
        "update design_templates
set multistate = 1
where
page_id = $row->{page_id}
and block_id = $row->{id}
and id not in (" . join(',', keys %has) . ")"
    );

    while (my ($k, $d) = each %update) {
        $app->partner_db->_do(
            "update design_templates
set opts=json_set(opts,'\$.design_settings', cast('$update{$k}' as json))
where id=$k"
        );
    }
}

sub update_PremiumVideoFormat {
    my ($app, $accessor, $row, $update, $opts) = @_;

    return unless $app->$accessor->DOES('Application::Model::Role::Block::Has::PremiumVideoFormat');
    $opts->{premium_video_format} = $row->{bk_data_custom}{PremiumVideoFormat} ? 1 : 0;
}

sub update_CustomBlockData {
    my ($app, $accessor, $row, $update, $opts) = @_;

    if ($app->$accessor->DOES('Application::Model::Role::Block::Has::ContentWidgetCommon')) {
        my $wi = $row->{bk_data_custom}{CustomBlockData}{WidgetInfo};
        $opts->{css}          = $wi->{CSS};
        $opts->{template}     = $wi->{Template};
        $opts->{grid_rows}    = $wi->{Height};
        $opts->{grid_columns} = $wi->{Width};

        $opts->{news_params} = {
            "candidates"     => [],
            "filter_clicked" => 0,
            "model_type"     => "ctr"
        };
        $opts->{need_pictures}     = undef;
        $opts->{adv_positions}     = undef;
        $opts->{sources}           = undef;
        $opts->{grid_position}     = undef;
        $opts->{doc_source}        = undef;
        $opts->{add_url_parameter} = undef;

        if ($app->$accessor->DOES('Application::Model::Role::Block::Has::ContentWidget')) {
            # старый формат
            if (exists $wi->{Sources}) {
                $opts->{sources} = $wi->{Sources};
                if (exists $wi->{AdvPosition}) {
                    if (ref $wi->{AdvPosition}) {
                        # https://st.yandex-team.ru/PI-18323#5dd563fd122154001edc4cf9
                        # Заменить на максимальную
                        $opts->{grid_position} = $opts->{grid_rows} * $opts->{grid_columns};
                    } else {
                        $opts->{grid_position} = $wi->{AdvPosition};
                    }
                }
            }
            # новый формат
            else {
                $opts->{adv_positions} = $wi->{AdvPosition};
                $opts->{need_pictures} = $wi->{NeedPictures} ? 1 : 0;
                $opts->{news_params}   = $wi->{NewsParams};
                if (my $np = $wi->{NewsParams}) {
                    if ($np->{doc_source}) {
                        $opts->{doc_source} = $np->{doc_source};
                    }
                    if ($np->{add_url_parameter}) {
                        $opts->{add_url_parameter} = $np->{add_url_parameter};
                    }
                }
            }
        }
    }
}

sub update_MediaSizes {
    my ($app, $row) = @_;

    my @data;
    my %has = ("0x0" => 1);
    for my $sr (@{$row->{bk_data_custom}{Sizes}}) {
        my $w = $sr->{Width} == 0 && $sr->{Height} != 0 ? '100%' : $sr->{Width};
        my $size = $w . 'x' . $sr->{Height};
        next if $has{$size};
        $has{$size} = 1;
        my %d = (
            page_id  => $row->{page_id},
            block_id => $row->{id},
            type     => $size,
        );
        push @data, \%d;
    }

    my $filter = $app->partner_db->filter({page_id => $row->{page_id}, block_id => $row->{id}});
    $app->partner_db->media_sizes->delete($filter);
    $app->partner_db->media_sizes->add_multi(\@data) if @data;
}

sub update_MediaBlock {
    my ($app, $accessor, $row, $update, $opts) = @_;

    if (    defined(my $h = $row->{bk_data_custom}{Height})
        and defined(my $w = $row->{bk_data_custom}{Width}))
    {
        if ($w == 0 and $h != 0) {
            $w = '100%';
        }
        $update->{media_block} = $w . 'x' . $h;
    }
    update_MediaSizes($app, $row);
}

sub update_DirectBlock {
    my ($app, $accessor, $row, $update, $opts) = @_;
    return;

    # if (    defined(my $h = $row->{bk_data_custom}{Height})
    #     and defined(my $w = $row->{bk_data_custom}{Width}))
    # {
    #     if ($w == 0 and $h == 0) {
    #         $update->{direct_block} = 'native';
    #     } else {
    #         $update->{direct_block} = $w . 'x' . $h;
    #     }
    # }

}

sub update_FormFactor {
    my ($app, $accessor, $row, $update, $opts) = @_;

    unless (defined $row->{table_data}{form_factor}) {
        $update->{form_factor} = 'vertical';
    }
}

1;
