#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';

=head1 пример вызова

   скрипт для поиска данных в результатах

   bin/oneshots/GM/check_result.pl --root=/home/ie2018/tmp/fix_bk_data.PI-19673 >bloks.txt

=cut

use lib::abs qw(../../../lib .);

use Time::HiRes qw(gettimeofday);

use qbit;

use GMUtils;
use GMHasDiff;
use GMFixBkData qw(fix_bk_data);
use GMFixBlockData qw(fix_block_data);
use GMDiffBkData qw(diff_bk_data);

main();

sub main {
    my $opts = get_opts();

    my $data = get_list_hashes($opts, 'has_diff.txt');

    0 && found_block_by_path($opts, $data, qr/^\.Sizes./,            'internal_context_on_site_rtb');
    0 && found_block_by_path($opts, $data, qr/^\.(?:Height|Width)$/, 'internal_context_on_site_rtb');
    1 && found_block_by_path_strict($opts, $data, qr/^\.(?:Height|Width)$/, 'internal_context_on_site_rtb');
}

# проверяем что в массиве только один элемент
sub check_data {
    my ($opts, $data) = @_;
    for my $block (@$data) {
        my $diff = $block->{diff};
        for my $key (keys %$diff) {
            unless (@{$diff->{$key}} == 1) {
                print $block->{block}{public_id}, "\n";
            }
        }
    }
}

# ищем блоки у которых есть непустые артикли и нет категорий
sub found_tns_wo_iab {
    my ($opts, $data) = @_;
    for my $block (@$data) {
        my $orig = $block->{orig};
        my $new  = $block->{new};
        if ($orig->{Article} and !$orig->{PICategoryIAB} and !%{$orig->{Article}}) {
            print $block->{block}{public_id}, "\n";
        }
    }
}

# ищем блоки в модели(если указана) у которых существует конкретное отличие
sub found_block_with_diff {
    my ($opts, $data, $path, $model) = @_;
    for my $block (@$data) {
        if ($model and $model ne $block->{block}{model}) {
            next;
        }
        if (
            exists $block->{diff}{$path}
            # and $block->{diff}{$path}[0][0] == 0
           )
        {
            print $block->{block}{public_id}, "\n";
            # print to_json($block->{orig}{AdType}, pretty => TRUE), "\n";
            # print to_json($block->{new}{AdType}, pretty => TRUE), "\n";
        }
    }
}

# ищем блоки в модели(если указана) у которых существует  отличие сооответствующее шаблону
sub found_block_by_path {
    my ($opts, $data, $path, $model) = @_;

    my %has;
    for my $block (@$data) {
        if ($model and $model ne $block->{block}{model}) {
            next;
        }
        for my $k (keys %{$block->{diff}}) {
            if ($k =~ $path) {
                print $block->{block}{public_id}, "\n";
                last;
            }
        }
    }
}

sub found_block_by_path_strict {
    my ($opts, $data, $path, $model) = @_;

    my %has;
    for my $block (@$data) {
        if ($model and $model ne $block->{block}{model}) {
            next;
        }
        my $has_other;
        for my $k (keys %{$block->{diff}}) {
            unless ($k =~ $path) {
                $has_other = 1;
            }
        }
        unless ($has_other) {
            print $block->{block}{public_id}, "\n";
        }
    }
}

sub found_pio {
    my ($opts, $data) = @_;

    for my $block (@$data) {
        for my $k (keys %{$block->{diff}}) {
            if ($k =~ /\.PageImpOptions\.(?:Enable|Disable)/) {
                if (@{$block->{orig}{PageImpOptions}{Enable}} > 1) {
                    print $block->{block}{public_id}, "\n";
                    print to_json($block->{orig}{PageImpOptions}, pretty => TRUE), "\n";
                }
                last;
            }
        }
    }
}

sub explore_validation {
    my ($opts, $data, $key) = @_;

    my %full;
    my %one;
    for my $block (@$data) {
        next unless ref $block->{validator};
        my $show;
        for my $e (@{$block->{validator}}) {
            if (grep {$_ eq $key} @{$e->{messages}}) {
                $show = 1;
                last;
            }
        }
        if ($show) {
            my @designs = grep {$_} keys %{$block->{new}{RtbDesign}};
            my @names   = map  {$block->{new}{RtbDesign}{$_}{design}{name}} @designs;
            @one{@names} = () if @names == 1;
            @full{@names} = ();
            print "$block->{block}{public_id} " . scalar(@designs) . " " . join(', ', @names) . "\n";
        }
    }
    print "-----\n", join("\n", keys %one), "\n";
    delete @full{keys %one};
    print "-----\n", join("\n", keys %full), "\n";
}

sub find_path_with_bool_diff {
    my ($opts, $data) = @_;

    for my $block (@$data) {
        for my $k (keys %{$block->{diff}}) {
            my $d = $block->{diff}{$k}[0];
            if (   ref $d->[0] eq 'JSON::XS::Boolean'
                or ref $d->[1] eq 'JSON::XS::Boolean')
            {
                print $k, " ", to_json($d), "\n";
            }
        }
    }
}

sub find_empty_array {
    my ($opts, $data) = @_;

    my %result;
    for my $block (@$data) {
        for my $k (keys %{$block->{diff}}) {
            my $d = $block->{diff}{$k}[0];
            if (!defined $d->[0] and defined $d->[1] and $d->[1] eq 'ARRAY') {
                push @{$result{$k}}, $block->{block}{public_id};
            }
        }
    }
    while (my ($k, $v) = each %result) {
        print "$k " . scalar(@$v) . "\n";
    }
}

sub found_block_with_adtypeset {
    my ($opts, $data) = @_;

    for my $block (@$data) {
        if (    scalar(keys %{$block->{diff}}) == 2
            and (my $m  = $block->{diff}{'.AdTypeSet.media'})
            and (my $mp = $block->{diff}{'.AdTypeSet.media-performance'}))
        {
            $m  = $m->[0];
            $mp = $mp->[0];
            if (    (defined($m->[0]) and $m->[0] == 0 and defined($m->[1]) and $m->[1] == 1)
                and (defined($mp->[0]) and $mp->[0] == 0 and defined($mp->[1]) and $mp->[1] == 1))
            {
                print $block->{block}{public_id}, "\n";
            }
        }
    }
}
