#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';

=head1 пример вызова

   скрипт для подготовки отчетов по дифам

   bin/oneshots/GM/report_diff.pl --root=/home/ie2018/tmp/fix_bk_data.PI-19674

=cut

use lib::abs qw(../../../lib .);

use Time::HiRes qw(gettimeofday);

use qbit;

use GMUtils;
use GMHasDiff;
use GMFixBkData qw(fix_bk_data);
use GMFixBlockData qw(fix_block_data);
use GMDiffBkData qw(diff_bk_data);

main_all();

sub main_all {
    my $opts = get_opts();

    if (1) {
        my $data = get_list_hashes($opts, 'has_diff.txt');
        make_report($opts, $data);
    }

    if (1) {
        my $data = get_list_hashes($opts, 'validation.txt');
        group_by_validation($opts, $data);
    }

    if (1) {
        my $data = get_list_hashes($opts, 'errors.txt');
        group_by_error($opts, $data);
    }
}

sub make_report {
    my ($opts, $data) = @_;

    my %path_by_model;
    my %count_by_model;
    my %block_by_model;
    my %block_count;
    for my $block (@$data) {
        my $diff  = $block->{diff};
        my $model = $block->{block}{model};

        $block_count{$model}++;
        $block_count{total}++;

        my %uniq;
        my @keys =
          grep {!$uniq{$_} and $uniq{$_} = 1}
          map {$_ =~ s/\d+/NNNNN/g; $_}

          # grep {$_ !~ /^\.PremiumVideoFormat$/}
          # grep {$_ !~ /^\.RtbDesign\.\d+\.design\.blockId$/}
          # grep {$_ !~ /^\.RtbDesign\.\d+\.design\.fullscreen$/}

          # grep {$_ !~ /^\.AdTypeSet/}
          # grep {$_ !~ /^\.AdType\./}
          #
          # grep {$_ !~ /^\.RtbDesign\.\d+$/}
          #
          # grep {$_ !~ /^\.DirectLimit$/}
          # grep {$_ !~ /^\.CustomBlockData\.WidgetInfo\.CSS$/}
          # grep {$_ !~ /^\.CustomBlockData$/}
          # grep {$_ !~ /^\.OptimizeType/}
          # grep {$_ !~ /^\.DSPInfo/}
          # grep {$_ !~ /^\.RtbDesign/}
          # grep {$_ !~ /^\.Design/}
          #
          # grep {$_ !~ /^\.TargetTags$/}
          # grep {$_ !~ /^\.OrderTags$/}
          #
          # grep {$_ !~ /^\.PICategoryIAB/}
          # grep {$_ !~ /^\.PageImpOptions/}
          # grep {$_ !~ /^\.Brand\.\d+/}
          #
          # grep {$_ !~ /^\.Sizes\.\[\d+\]/}
          # grep {$_ !~ /^\.Width$/}
          # grep {$_ !~ /^\.Height$/}
          keys %$diff;

        for my $path (@keys) {
            $path_by_model{$model}{$path}++;
            $path_by_model{total}{$path}++;
        }
        $count_by_model{$model}{scalar @keys}++;
        $count_by_model{total}{scalar @keys}++;
        if (@keys and @keys < 4) {
            push @{$block_by_model{$model}{scalar @keys}{join('|', sort @keys)}}, $block->{block}{public_id};
            push @{$block_by_model{total}{scalar @keys}{join('|', sort @keys)}}, $block->{block}{public_id};
        }
    }
    for my $model (keys %path_by_model) {
        writefile(
            prepare_path($opts->{root}, "diff", "path_$model.tsv"),
            to_csv([qw(path count)], hash_to_array($path_by_model{$model}))
        );
        writefile(
            prepare_path($opts->{root}, "diff", "count_$model.tsv"),
            to_csv([qw(cd count)], hash_to_array($count_by_model{$model}))
        );
        if ($block_by_model{$model}) {
            for my $count (keys %{$block_by_model{$model}}) {
                my @data;
                for my $path (keys %{$block_by_model{$model}{$count}}) {
                    my $l = $block_by_model{$model}{$count}{$path};
                    push @data, [scalar @$l, $path, join(', ', @$l)];
                }
                writefile(
                    prepare_path($opts->{root}, "diff", "blocks_${model}_$count.tsv"),
                    to_csv([qw(count path blocks)], [sort {$b->[0] <=> $a->[0]} @data])
                );
            }
        }
    }
    writefile(
        prepare_path($opts->{root}, "diff", "block_by_model.tsv"),
        to_csv([qw(model count)], hash_to_array(\%block_count))
    );
}

sub group_by_error {
    my ($opts, $data) = @_;
    my %ue;
    for my $block (@$data) {
        my @e = split /\n/, $block->{error};
        push @{$ue{$e[0]}}, $block->{public_id};
    }

    my $cnt = 0;
    for my $e (keys %ue) {
        $cnt++;
        writefile(prepare_path($opts->{root}, "error", scalar(@{$ue{$e}}) . "-$cnt.txt"),
            $e . "\n" . join("\n", @{$ue{$e}}) . "\n");
    }
}

sub group_by_validation {
    my ($opts, $data) = @_;
    my %um;
    for my $block (@$data) {
        my @m;
        unless (ref $block->{validator}) {
            push @m, $block->{validator};
        } else {
            for my $e (@{$block->{validator}}) {
                push @m, @{$e->{messages}};
            }
        }
        for my $m (@m) {
            $um{$m}{$block->{block}{public_id}} = 1;
        }
    }

    my $cnt = 0;
    for my $m (keys %um) {
        $cnt++;
        my @ary = keys %{$um{$m}};
        writefile(prepare_path($opts->{root}, "validation", scalar(@ary) . "-$cnt.txt"),
            $m . "\n" . join("\n", @ary) . "\n");
    }
}
