#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';

=head1 пример вызова

   скрипт для генерации отчета по логинам

   bin/oneshots/GM/report_for_login.pl --root=/home/ie2018/tmp/fix_bk_data.PI-19674 --list=rambler-p

=cut

use lib::abs qw(../../../lib .);

use Time::HiRes qw(gettimeofday);

use qbit;

use GMUtils;
use GMHasDiff;
use GMFixBkData qw(fix_bk_data);
use GMFixBlockData qw(fix_block_data);
use GMDiffBkData qw(diff_bk_data);

main_report();

sub main_report {
    my $opts = get_opts('list');

    my %need_login = map {$_ => 1} @{$opts->{list}};
    my %need_block;
    for my $block (
        @{
            from_csv([qw(public_id model login domain money is_deleted c_date fixed)],
                "$opts->{root}/full_block_data.tsv")
        }
      )
    {
        $need_block{$block->{public_id}} = $block->{login} if $need_login{$block->{login}};
    }

    my $diff  = get_list_hashes($opts, 'has_diff.txt');
    my $valid = get_list_hashes($opts, 'validation.txt');
    my $error = get_list_hashes($opts, 'errors.txt');

    my %ndiff  = map {$_ => []} @{$opts->{list}};
    my %nvalid = map {$_ => []} @{$opts->{list}};
    my %nerror = map {$_ => []} @{$opts->{list}};

    for my $row (@$valid) {
        if (my $login = $need_block{$row->{block}{public_id}}) {
            push @{$nvalid{$login}}, $row;
        }
    }
    for my $row (@$error) {
        if (my $login = $need_block{$row->{public_id}}) {
            push @{$nerror{$login}}, $row;
        }
    }
    for my $row (@$diff) {
        if (my $login = $need_block{$row->{block}{public_id}}) {
            push @{$ndiff{$login}}, $row;
        }
    }

    for my $login (@{$opts->{list}}) {
        writefile(prepare_path($opts->{root}, 'by_login', $login, 'has_diff.txt'),   to_list_hashes($ndiff{$login}));
        writefile(prepare_path($opts->{root}, 'by_login', $login, 'validation.txt'), to_list_hashes($nvalid{$login}));
        writefile(prepare_path($opts->{root}, 'by_login', $login, 'errors.txt'),     to_list_hashes($nerror{$login}));
        system("bin/oneshots/GM/report_diff.pl --root=$opts->{root}/by_login/$login");
    }
}

sub to_list_hashes {
    my ($data) = @_;
    return join '', map(to_json($_, pretty => 1), @$data);
}
