#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ./../../lib
  );
use qbit;
use Application;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    my $yndx_bessarabov_user_id = 155209804;
    $app->set_cur_user({id => $yndx_bessarabov_user_id});

    while (my $line = <DATA>) {
        chomp $line;

        my ($json) = $line =~ /^({.*}) -/;
        my $obj = from_json $json;

        my $rtb_block_before =
          $app->context_on_site_rtb->get($obj, fields => [qw(public_id direct_block url_background_color)],);

        my $adfox_block = $app->partner_db->_get_all(
            'select url_background_color from context_on_site_adfox where campaign_id = ? and id = ?',
            $obj->{campaign_id}, $obj->{id},);

        warn to_json(
            {
                rtb_block_before              => $rtb_block_before,
                url_background_color_in_adfox => $adfox_block->[0]->{url_background_color},
            },
            canonical => 1
        ) . "\n";

        if ($adfox_block->[0]->{url_background_color} ne ($rtb_block_before->{url_background_color} // '')) {
            $app->partner_db->context_on_site_rtb->edit($obj,
                {url_background_color => $adfox_block->[0]->{url_background_color}});
        }
    }

    $app->post_run();
    say "#END";
}
main();
__DATA__
{"id":"1","campaign_id":"1645"} - url_background_color
{"id":"1","campaign_id":"17589"} - url_background_color
{"id":"1","campaign_id":"23106"} - url_background_color
{"id":"1","campaign_id":"23597"} - url_background_color
{"id":"1","campaign_id":"84858"} - url_background_color
{"id":"1","campaign_id":"100667"} - url_background_color
{"id":"1","campaign_id":"114819"} - url_background_color
{"id":"1","campaign_id":"117192"} - url_background_color
{"id":"1","campaign_id":"138726"} - url_background_color
{"id":"1","campaign_id":"139129"} - url_background_color
{"id":"1","campaign_id":"143062"} - url_background_color
{"id":"1","campaign_id":"143063"} - url_background_color
{"id":"1","campaign_id":"143064"} - url_background_color
{"id":"1","campaign_id":"143067"} - url_background_color
{"id":"1","campaign_id":"143320"} - url_background_color
{"id":"1","campaign_id":"144202"} - url_background_color
{"id":"1","campaign_id":"147547"} - url_background_color
{"id":"1","campaign_id":"148649"} - url_background_color
{"id":"1","campaign_id":"148936"} - url_background_color
{"id":"1","campaign_id":"148944"} - url_background_color
{"id":"1","campaign_id":"149809"} - url_background_color
{"id":"1","campaign_id":"161353"} - url_background_color
{"id":"1","campaign_id":"161361"} - url_background_color
{"id":"1","campaign_id":"229003"} - url_background_color
{"id":"1","campaign_id":"232061"} - url_background_color
{"id":"1","campaign_id":"239983"} - url_background_color
{"id":"1","campaign_id":"241384"} - url_background_color
{"id":"1","campaign_id":"243892"} - url_background_color
{"id":"1","campaign_id":"243948"} - url_background_color
{"id":"1","campaign_id":"243983"} - url_background_color
{"id":"1","campaign_id":"244876"} - url_background_color
{"id":"1","campaign_id":"245300"} - url_background_color
{"id":"1","campaign_id":"245371"} - url_background_color
{"id":"1","campaign_id":"245393"} - url_background_color
{"id":"1","campaign_id":"245395"} - url_background_color
{"id":"1","campaign_id":"247287"} - url_background_color
{"id":"1","campaign_id":"249298"} - url_background_color
{"id":"1","campaign_id":"249836"} - url_background_color
{"id":"1","campaign_id":"250544"} - url_background_color
{"id":"1","campaign_id":"251756"} - url_background_color
{"id":"1","campaign_id":"255911"} - url_background_color
{"id":"1","campaign_id":"257828"} - url_background_color
{"id":"2","campaign_id":"63097"} - url_background_color
{"id":"2","campaign_id":"68794"} - url_background_color
{"id":"2","campaign_id":"73403"} - url_background_color
{"id":"2","campaign_id":"84858"} - url_background_color
{"id":"2","campaign_id":"114819"} - url_background_color
{"id":"2","campaign_id":"129433"} - url_background_color
{"id":"2","campaign_id":"132801"} - url_background_color
{"id":"2","campaign_id":"139129"} - url_background_color
{"id":"2","campaign_id":"143062"} - url_background_color
{"id":"2","campaign_id":"143065"} - url_background_color
{"id":"2","campaign_id":"143066"} - url_background_color
{"id":"2","campaign_id":"143320"} - url_background_color
{"id":"2","campaign_id":"144202"} - url_background_color
{"id":"2","campaign_id":"145406"} - url_background_color
{"id":"2","campaign_id":"146357"} - url_background_color
{"id":"2","campaign_id":"147547"} - url_background_color
{"id":"2","campaign_id":"148649"} - url_background_color
{"id":"2","campaign_id":"148944"} - url_background_color
{"id":"2","campaign_id":"154219"} - url_background_color
{"id":"2","campaign_id":"161360"} - url_background_color
{"id":"2","campaign_id":"169259"} - url_background_color
{"id":"2","campaign_id":"183557"} - url_background_color
{"id":"2","campaign_id":"183621"} - url_background_color
{"id":"2","campaign_id":"184991"} - url_background_color
{"id":"2","campaign_id":"200236"} - url_background_color
{"id":"2","campaign_id":"207486"} - url_background_color
{"id":"2","campaign_id":"207766"} - url_background_color
{"id":"2","campaign_id":"208366"} - url_background_color
{"id":"2","campaign_id":"212356"} - url_background_color
{"id":"2","campaign_id":"224553"} - url_background_color
{"id":"2","campaign_id":"231885"} - url_background_color
{"id":"2","campaign_id":"232061"} - url_background_color
{"id":"2","campaign_id":"232311"} - url_background_color
{"id":"2","campaign_id":"239983"} - url_background_color
{"id":"2","campaign_id":"241680"} - url_background_color
{"id":"2","campaign_id":"241835"} - url_background_color
{"id":"2","campaign_id":"243343"} - url_background_color
{"id":"2","campaign_id":"243892"} - url_background_color
{"id":"2","campaign_id":"243952"} - url_background_color
{"id":"2","campaign_id":"243990"} - url_background_color
{"id":"2","campaign_id":"244876"} - url_background_color
{"id":"2","campaign_id":"248737"} - url_background_color
{"id":"2","campaign_id":"248738"} - url_background_color
{"id":"2","campaign_id":"248800"} - url_background_color
{"id":"2","campaign_id":"249518"} - url_background_color
{"id":"2","campaign_id":"249836"} - url_background_color
{"id":"2","campaign_id":"250433"} - url_background_color
{"id":"2","campaign_id":"251597"} - url_background_color
{"id":"2","campaign_id":"251756"} - url_background_color
{"id":"2","campaign_id":"255091"} - url_background_color
{"id":"2","campaign_id":"256085"} - url_background_color
{"id":"2","campaign_id":"256845"} - url_background_color
{"id":"3","campaign_id":"49828"} - url_background_color
{"id":"3","campaign_id":"63097"} - url_background_color
{"id":"3","campaign_id":"94200"} - url_background_color
{"id":"3","campaign_id":"107957"} - url_background_color
{"id":"3","campaign_id":"113903"} - url_background_color
{"id":"3","campaign_id":"121143"} - url_background_color
{"id":"3","campaign_id":"127976"} - url_background_color
{"id":"3","campaign_id":"136716"} - url_background_color
{"id":"3","campaign_id":"138072"} - url_background_color
{"id":"3","campaign_id":"139129"} - url_background_color
{"id":"3","campaign_id":"141090"} - url_background_color
{"id":"3","campaign_id":"141737"} - url_background_color
{"id":"3","campaign_id":"144202"} - url_background_color
{"id":"3","campaign_id":"145406"} - url_background_color
{"id":"3","campaign_id":"146357"} - url_background_color
{"id":"3","campaign_id":"149606"} - url_background_color
{"id":"3","campaign_id":"151504"} - url_background_color
{"id":"3","campaign_id":"154219"} - url_background_color
{"id":"3","campaign_id":"158931"} - url_background_color
{"id":"3","campaign_id":"175106"} - url_background_color
{"id":"3","campaign_id":"183979"} - url_background_color
{"id":"3","campaign_id":"188279"} - url_background_color
{"id":"3","campaign_id":"207486"} - url_background_color
{"id":"3","campaign_id":"207766"} - url_background_color
{"id":"3","campaign_id":"226157"} - url_background_color
{"id":"3","campaign_id":"232061"} - url_background_color
{"id":"3","campaign_id":"232200"} - url_background_color
{"id":"3","campaign_id":"235122"} - url_background_color
{"id":"3","campaign_id":"237573"} - url_background_color
{"id":"3","campaign_id":"241527"} - url_background_color
{"id":"3","campaign_id":"243948"} - url_background_color
{"id":"3","campaign_id":"243950"} - url_background_color
{"id":"3","campaign_id":"243951"} - url_background_color
{"id":"3","campaign_id":"243952"} - url_background_color
{"id":"3","campaign_id":"243954"} - url_background_color
{"id":"3","campaign_id":"243984"} - url_background_color
{"id":"3","campaign_id":"243985"} - url_background_color
{"id":"3","campaign_id":"243986"} - url_background_color
{"id":"3","campaign_id":"243987"} - url_background_color
{"id":"3","campaign_id":"244876"} - url_background_color
{"id":"3","campaign_id":"247455"} - url_background_color
{"id":"3","campaign_id":"248715"} - url_background_color
{"id":"3","campaign_id":"248717"} - url_background_color
{"id":"3","campaign_id":"248737"} - url_background_color
{"id":"3","campaign_id":"248738"} - url_background_color
{"id":"3","campaign_id":"248947"} - url_background_color
{"id":"3","campaign_id":"249160"} - url_background_color
{"id":"3","campaign_id":"249836"} - url_background_color
{"id":"3","campaign_id":"251078"} - url_background_color
{"id":"3","campaign_id":"251756"} - url_background_color
{"id":"3","campaign_id":"256068"} - url_background_color
{"id":"3","campaign_id":"256085"} - url_background_color
{"id":"3","campaign_id":"257828"} - url_background_color
{"id":"4","campaign_id":"63097"} - url_background_color
{"id":"4","campaign_id":"84858"} - url_background_color
{"id":"4","campaign_id":"91389"} - url_background_color
{"id":"4","campaign_id":"106634"} - url_background_color
{"id":"4","campaign_id":"107957"} - url_background_color
{"id":"4","campaign_id":"113903"} - url_background_color
{"id":"4","campaign_id":"132801"} - url_background_color
{"id":"4","campaign_id":"132860"} - url_background_color
{"id":"4","campaign_id":"139129"} - url_background_color
{"id":"4","campaign_id":"139612"} - url_background_color
{"id":"4","campaign_id":"141735"} - url_background_color
{"id":"4","campaign_id":"141736"} - url_background_color
{"id":"4","campaign_id":"141739"} - url_background_color
{"id":"4","campaign_id":"143061"} - url_background_color
{"id":"4","campaign_id":"143065"} - url_background_color
{"id":"4","campaign_id":"144200"} - url_background_color
{"id":"4","campaign_id":"144202"} - url_background_color
{"id":"4","campaign_id":"145406"} - url_background_color
{"id":"4","campaign_id":"147089"} - url_background_color
{"id":"4","campaign_id":"149606"} - url_background_color
{"id":"4","campaign_id":"154219"} - url_background_color
{"id":"4","campaign_id":"161360"} - url_background_color
{"id":"4","campaign_id":"184419"} - url_background_color
{"id":"4","campaign_id":"184991"} - url_background_color
{"id":"4","campaign_id":"188279"} - url_background_color
{"id":"4","campaign_id":"226157"} - url_background_color
{"id":"4","campaign_id":"235122"} - url_background_color
{"id":"4","campaign_id":"235482"} - url_background_color
{"id":"4","campaign_id":"236329"} - url_background_color
{"id":"4","campaign_id":"242216"} - url_background_color
{"id":"4","campaign_id":"243954"} - url_background_color
{"id":"4","campaign_id":"244876"} - url_background_color
{"id":"4","campaign_id":"245393"} - url_background_color
{"id":"4","campaign_id":"247455"} - url_background_color
{"id":"4","campaign_id":"248472"} - url_background_color
{"id":"4","campaign_id":"248725"} - url_background_color
{"id":"4","campaign_id":"248947"} - url_background_color
{"id":"4","campaign_id":"248966"} - url_background_color
{"id":"4","campaign_id":"249160"} - url_background_color
{"id":"4","campaign_id":"249298"} - url_background_color
{"id":"4","campaign_id":"249834"} - url_background_color
{"id":"4","campaign_id":"249836"} - url_background_color
{"id":"4","campaign_id":"251756"} - url_background_color
{"id":"4","campaign_id":"252805"} - url_background_color
{"id":"4","campaign_id":"255911"} - url_background_color
{"id":"4","campaign_id":"256068"} - url_background_color
{"id":"4","campaign_id":"256085"} - url_background_color
{"id":"4","campaign_id":"257828"} - url_background_color
{"id":"5","campaign_id":"46249"} - url_background_color
{"id":"5","campaign_id":"48231"} - url_background_color
{"id":"5","campaign_id":"63097"} - url_background_color
{"id":"5","campaign_id":"73403"} - url_background_color
{"id":"5","campaign_id":"91389"} - url_background_color
{"id":"5","campaign_id":"113903"} - url_background_color
{"id":"5","campaign_id":"119532"} - url_background_color
{"id":"5","campaign_id":"132801"} - url_background_color
{"id":"5","campaign_id":"134625"} - url_background_color
{"id":"5","campaign_id":"134627"} - url_background_color
{"id":"5","campaign_id":"139612"} - url_background_color
{"id":"5","campaign_id":"141737"} - url_background_color
{"id":"5","campaign_id":"141738"} - url_background_color
{"id":"5","campaign_id":"144685"} - url_background_color
{"id":"5","campaign_id":"145406"} - url_background_color
{"id":"5","campaign_id":"146357"} - url_background_color
{"id":"5","campaign_id":"147473"} - url_background_color
{"id":"5","campaign_id":"154219"} - url_background_color
{"id":"5","campaign_id":"167170"} - url_background_color
{"id":"5","campaign_id":"172264"} - url_background_color
{"id":"5","campaign_id":"175106"} - url_background_color
{"id":"5","campaign_id":"184991"} - url_background_color
{"id":"5","campaign_id":"188279"} - url_background_color
{"id":"5","campaign_id":"207766"} - url_background_color
{"id":"5","campaign_id":"229003"} - url_background_color
{"id":"5","campaign_id":"232061"} - url_background_color
{"id":"5","campaign_id":"232311"} - url_background_color
{"id":"5","campaign_id":"235122"} - url_background_color
{"id":"5","campaign_id":"236315"} - url_background_color
{"id":"5","campaign_id":"243892"} - url_background_color
{"id":"5","campaign_id":"243950"} - url_background_color
{"id":"5","campaign_id":"243951"} - url_background_color
{"id":"5","campaign_id":"243952"} - url_background_color
{"id":"5","campaign_id":"243954"} - url_background_color
{"id":"5","campaign_id":"243984"} - url_background_color
{"id":"5","campaign_id":"243985"} - url_background_color
{"id":"5","campaign_id":"243986"} - url_background_color
{"id":"5","campaign_id":"243987"} - url_background_color
{"id":"5","campaign_id":"244876"} - url_background_color
{"id":"5","campaign_id":"248472"} - url_background_color
{"id":"5","campaign_id":"248966"} - url_background_color
{"id":"5","campaign_id":"249160"} - url_background_color
{"id":"5","campaign_id":"249298"} - url_background_color
{"id":"5","campaign_id":"249836"} - url_background_color
{"id":"5","campaign_id":"251597"} - url_background_color
{"id":"5","campaign_id":"255911"} - url_background_color
{"id":"6","campaign_id":"1400"} - url_background_color
{"id":"6","campaign_id":"45674"} - url_background_color
{"id":"6","campaign_id":"46249"} - url_background_color
{"id":"6","campaign_id":"49828"} - url_background_color
{"id":"6","campaign_id":"49890"} - url_background_color
{"id":"6","campaign_id":"73403"} - url_background_color
{"id":"6","campaign_id":"84858"} - url_background_color
{"id":"6","campaign_id":"95572"} - url_background_color
{"id":"6","campaign_id":"113903"} - url_background_color
{"id":"6","campaign_id":"119532"} - url_background_color
{"id":"6","campaign_id":"136274"} - url_background_color
{"id":"6","campaign_id":"138917"} - url_background_color
{"id":"6","campaign_id":"139085"} - url_background_color
{"id":"6","campaign_id":"141716"} - url_background_color
{"id":"6","campaign_id":"141735"} - url_background_color
{"id":"6","campaign_id":"141736"} - url_background_color
{"id":"6","campaign_id":"141739"} - url_background_color
{"id":"6","campaign_id":"143061"} - url_background_color
{"id":"6","campaign_id":"144685"} - url_background_color
{"id":"6","campaign_id":"144838"} - url_background_color
{"id":"6","campaign_id":"145353"} - url_background_color
{"id":"6","campaign_id":"145406"} - url_background_color
{"id":"6","campaign_id":"146357"} - url_background_color
{"id":"6","campaign_id":"147473"} - url_background_color
{"id":"6","campaign_id":"184162"} - url_background_color
{"id":"6","campaign_id":"184991"} - url_background_color
{"id":"6","campaign_id":"188279"} - url_background_color
{"id":"6","campaign_id":"207766"} - url_background_color
{"id":"6","campaign_id":"224315"} - url_background_color
{"id":"6","campaign_id":"226091"} - url_background_color
{"id":"6","campaign_id":"232061"} - url_background_color
{"id":"6","campaign_id":"232311"} - url_background_color
{"id":"6","campaign_id":"235122"} - url_background_color
{"id":"6","campaign_id":"242216"} - url_background_color
{"id":"6","campaign_id":"243892"} - url_background_color
{"id":"6","campaign_id":"243954"} - url_background_color
{"id":"6","campaign_id":"248966"} - url_background_color
{"id":"6","campaign_id":"249298"} - url_background_color
{"id":"6","campaign_id":"251597"} - url_background_color
{"id":"7","campaign_id":"1400"} - url_background_color
{"id":"7","campaign_id":"17418"} - url_background_color
{"id":"7","campaign_id":"46249"} - url_background_color
{"id":"7","campaign_id":"69257"} - url_background_color
{"id":"7","campaign_id":"69875"} - url_background_color
{"id":"7","campaign_id":"78239"} - url_background_color
{"id":"7","campaign_id":"79460"} - url_background_color
{"id":"7","campaign_id":"84858"} - url_background_color
{"id":"7","campaign_id":"100631"} - url_background_color
{"id":"7","campaign_id":"113903"} - url_background_color
{"id":"7","campaign_id":"128871"} - url_background_color
{"id":"7","campaign_id":"130866"} - url_background_color
{"id":"7","campaign_id":"131071"} - url_background_color
{"id":"7","campaign_id":"134625"} - url_background_color
{"id":"7","campaign_id":"136274"} - url_background_color
{"id":"7","campaign_id":"136716"} - url_background_color
{"id":"7","campaign_id":"141738"} - url_background_color
{"id":"7","campaign_id":"144036"} - url_background_color
{"id":"7","campaign_id":"145353"} - url_background_color
{"id":"7","campaign_id":"145406"} - url_background_color
{"id":"7","campaign_id":"146357"} - url_background_color
{"id":"7","campaign_id":"147473"} - url_background_color
{"id":"7","campaign_id":"183919"} - url_background_color
{"id":"7","campaign_id":"188279"} - url_background_color
{"id":"7","campaign_id":"191304"} - url_background_color
{"id":"7","campaign_id":"207766"} - url_background_color
{"id":"7","campaign_id":"212680"} - url_background_color
{"id":"7","campaign_id":"224315"} - url_background_color
{"id":"7","campaign_id":"229003"} - url_background_color
{"id":"7","campaign_id":"232061"} - url_background_color
{"id":"7","campaign_id":"232311"} - url_background_color
{"id":"7","campaign_id":"235122"} - url_background_color
{"id":"7","campaign_id":"237404"} - url_background_color
{"id":"7","campaign_id":"243954"} - url_background_color
{"id":"7","campaign_id":"243984"} - url_background_color
{"id":"7","campaign_id":"243985"} - url_background_color
{"id":"7","campaign_id":"245301"} - url_background_color
{"id":"7","campaign_id":"248715"} - url_background_color
{"id":"7","campaign_id":"248966"} - url_background_color
{"id":"7","campaign_id":"249111"} - url_background_color
{"id":"7","campaign_id":"249298"} - url_background_color
{"id":"7","campaign_id":"255911"} - url_background_color
{"id":"8","campaign_id":"50665"} - url_background_color
{"id":"8","campaign_id":"78239"} - url_background_color
{"id":"8","campaign_id":"79460"} - url_background_color
{"id":"8","campaign_id":"95572"} - url_background_color
{"id":"8","campaign_id":"100631"} - url_background_color
{"id":"8","campaign_id":"113903"} - url_background_color
{"id":"8","campaign_id":"117050"} - url_background_color
{"id":"8","campaign_id":"131071"} - url_background_color
{"id":"8","campaign_id":"132801"} - url_background_color
{"id":"8","campaign_id":"134625"} - url_background_color
{"id":"8","campaign_id":"138071"} - url_background_color
{"id":"8","campaign_id":"138437"} - url_background_color
{"id":"8","campaign_id":"141716"} - url_background_color
{"id":"8","campaign_id":"145528"} - url_background_color
{"id":"8","campaign_id":"146357"} - url_background_color
{"id":"8","campaign_id":"147473"} - url_background_color
{"id":"8","campaign_id":"149156"} - url_background_color
{"id":"8","campaign_id":"150693"} - url_background_color
{"id":"8","campaign_id":"154768"} - url_background_color
{"id":"8","campaign_id":"162377"} - url_background_color
{"id":"8","campaign_id":"207461"} - url_background_color
{"id":"8","campaign_id":"212680"} - url_background_color
{"id":"8","campaign_id":"229003"} - url_background_color
{"id":"8","campaign_id":"232061"} - url_background_color
{"id":"8","campaign_id":"235122"} - url_background_color
{"id":"8","campaign_id":"237404"} - url_background_color
{"id":"8","campaign_id":"242216"} - url_background_color
{"id":"8","campaign_id":"243954"} - url_background_color
{"id":"8","campaign_id":"245301"} - url_background_color
{"id":"8","campaign_id":"248715"} - url_background_color
{"id":"8","campaign_id":"249111"} - url_background_color
{"id":"8","campaign_id":"249160"} - url_background_color
{"id":"8","campaign_id":"249836"} - url_background_color
{"id":"8","campaign_id":"250724"} - url_background_color
{"id":"8","campaign_id":"252422"} - url_background_color
{"id":"9","campaign_id":"46249"} - url_background_color
{"id":"9","campaign_id":"78239"} - url_background_color
{"id":"9","campaign_id":"113903"} - url_background_color
{"id":"9","campaign_id":"128871"} - url_background_color
{"id":"9","campaign_id":"132801"} - url_background_color
{"id":"9","campaign_id":"134625"} - url_background_color
{"id":"9","campaign_id":"134627"} - url_background_color
{"id":"9","campaign_id":"136800"} - url_background_color
{"id":"9","campaign_id":"144838"} - url_background_color
{"id":"9","campaign_id":"145528"} - url_background_color
{"id":"9","campaign_id":"145986"} - url_background_color
{"id":"9","campaign_id":"146357"} - url_background_color
{"id":"9","campaign_id":"148545"} - url_background_color
{"id":"9","campaign_id":"149156"} - url_background_color
{"id":"9","campaign_id":"154950"} - url_background_color
{"id":"9","campaign_id":"158933"} - url_background_color
{"id":"9","campaign_id":"229003"} - url_background_color
{"id":"9","campaign_id":"235122"} - url_background_color
{"id":"9","campaign_id":"237404"} - url_background_color
{"id":"9","campaign_id":"243892"} - url_background_color
{"id":"9","campaign_id":"243950"} - url_background_color
{"id":"9","campaign_id":"243953"} - url_background_color
{"id":"9","campaign_id":"243954"} - url_background_color
{"id":"9","campaign_id":"243988"} - url_background_color
{"id":"9","campaign_id":"245301"} - url_background_color
{"id":"9","campaign_id":"248715"} - url_background_color
{"id":"9","campaign_id":"249111"} - url_background_color
{"id":"9","campaign_id":"249836"} - url_background_color
{"id":"9","campaign_id":"250724"} - url_background_color
{"id":"9","campaign_id":"252422"} - url_background_color
{"id":"10","campaign_id":"46249"} - url_background_color
{"id":"10","campaign_id":"64108"} - url_background_color
{"id":"10","campaign_id":"69257"} - url_background_color
{"id":"10","campaign_id":"78239"} - url_background_color
{"id":"10","campaign_id":"117050"} - url_background_color
{"id":"10","campaign_id":"131071"} - url_background_color
{"id":"10","campaign_id":"134627"} - url_background_color
{"id":"10","campaign_id":"145406"} - url_background_color
{"id":"10","campaign_id":"145528"} - url_background_color
{"id":"10","campaign_id":"149156"} - url_background_color
{"id":"10","campaign_id":"187127"} - url_background_color
{"id":"10","campaign_id":"207461"} - url_background_color
{"id":"10","campaign_id":"207766"} - url_background_color
{"id":"10","campaign_id":"224553"} - url_background_color
{"id":"10","campaign_id":"232311"} - url_background_color
{"id":"10","campaign_id":"235122"} - url_background_color
{"id":"10","campaign_id":"237404"} - url_background_color
{"id":"10","campaign_id":"243892"} - url_background_color
{"id":"10","campaign_id":"243953"} - url_background_color
{"id":"10","campaign_id":"243954"} - url_background_color
{"id":"10","campaign_id":"243988"} - url_background_color
{"id":"10","campaign_id":"245301"} - url_background_color
{"id":"10","campaign_id":"248715"} - url_background_color
{"id":"10","campaign_id":"249111"} - url_background_color
{"id":"10","campaign_id":"249160"} - url_background_color
{"id":"10","campaign_id":"249836"} - url_background_color
{"id":"10","campaign_id":"250724"} - url_background_color
{"id":"11","campaign_id":"123129"} - url_background_color
{"id":"11","campaign_id":"127611"} - url_background_color
{"id":"11","campaign_id":"134627"} - url_background_color
{"id":"11","campaign_id":"136800"} - url_background_color
{"id":"11","campaign_id":"145406"} - url_background_color
{"id":"11","campaign_id":"149156"} - url_background_color
{"id":"11","campaign_id":"154962"} - url_background_color
{"id":"11","campaign_id":"183621"} - url_background_color
{"id":"11","campaign_id":"187127"} - url_background_color
{"id":"11","campaign_id":"224553"} - url_background_color
{"id":"11","campaign_id":"229003"} - url_background_color
{"id":"11","campaign_id":"235122"} - url_background_color
{"id":"11","campaign_id":"243892"} - url_background_color
{"id":"11","campaign_id":"243950"} - url_background_color
{"id":"11","campaign_id":"243954"} - url_background_color
{"id":"11","campaign_id":"247392"} - url_background_color
{"id":"11","campaign_id":"249111"} - url_background_color
{"id":"11","campaign_id":"249160"} - url_background_color
{"id":"11","campaign_id":"250724"} - url_background_color
{"id":"12","campaign_id":"52223"} - url_background_color
{"id":"12","campaign_id":"64939"} - url_background_color
{"id":"12","campaign_id":"123129"} - url_background_color
{"id":"12","campaign_id":"127611"} - url_background_color
{"id":"12","campaign_id":"145406"} - url_background_color
{"id":"12","campaign_id":"158933"} - url_background_color
{"id":"12","campaign_id":"187127"} - url_background_color
{"id":"12","campaign_id":"193924"} - url_background_color
{"id":"12","campaign_id":"204310"} - url_background_color
{"id":"12","campaign_id":"224553"} - url_background_color
{"id":"12","campaign_id":"243892"} - url_background_color
{"id":"12","campaign_id":"245301"} - url_background_color
{"id":"12","campaign_id":"249111"} - url_background_color
{"id":"12","campaign_id":"249836"} - url_background_color
{"id":"12","campaign_id":"250043"} - url_background_color
{"id":"13","campaign_id":"1262"} - url_background_color
{"id":"13","campaign_id":"51486"} - url_background_color
{"id":"13","campaign_id":"64939"} - url_background_color
{"id":"13","campaign_id":"94052"} - url_background_color
{"id":"13","campaign_id":"127611"} - url_background_color
{"id":"13","campaign_id":"129405"} - url_background_color
{"id":"13","campaign_id":"130866"} - url_background_color
{"id":"13","campaign_id":"148545"} - url_background_color
{"id":"13","campaign_id":"149156"} - url_background_color
{"id":"13","campaign_id":"168321"} - url_background_color
{"id":"13","campaign_id":"187127"} - url_background_color
{"id":"13","campaign_id":"224553"} - url_background_color
{"id":"13","campaign_id":"241527"} - url_background_color
{"id":"13","campaign_id":"242216"} - url_background_color
{"id":"13","campaign_id":"243892"} - url_background_color
{"id":"13","campaign_id":"249836"} - url_background_color
{"id":"13","campaign_id":"250043"} - url_background_color
{"id":"14","campaign_id":"27397"} - url_background_color
{"id":"14","campaign_id":"51486"} - url_background_color
{"id":"14","campaign_id":"145406"} - url_background_color
{"id":"14","campaign_id":"149156"} - url_background_color
{"id":"14","campaign_id":"149255"} - url_background_color
{"id":"14","campaign_id":"187127"} - url_background_color
{"id":"14","campaign_id":"205913"} - url_background_color
{"id":"14","campaign_id":"210170"} - url_background_color
{"id":"14","campaign_id":"214684"} - url_background_color
{"id":"14","campaign_id":"228362"} - url_background_color
{"id":"14","campaign_id":"232311"} - url_background_color
{"id":"14","campaign_id":"243892"} - url_background_color
{"id":"14","campaign_id":"249111"} - url_background_color
{"id":"14","campaign_id":"249836"} - url_background_color
{"id":"15","campaign_id":"123129"} - url_background_color
{"id":"15","campaign_id":"127873"} - url_background_color
{"id":"15","campaign_id":"131228"} - url_background_color
{"id":"15","campaign_id":"134625"} - url_background_color
{"id":"15","campaign_id":"139652"} - url_background_color
{"id":"15","campaign_id":"144951"} - url_background_color
{"id":"15","campaign_id":"145406"} - url_background_color
{"id":"15","campaign_id":"148545"} - url_background_color
{"id":"15","campaign_id":"149255"} - url_background_color
{"id":"15","campaign_id":"187127"} - url_background_color
{"id":"15","campaign_id":"243892"} - url_background_color
{"id":"15","campaign_id":"249836"} - url_background_color
{"id":"16","campaign_id":"79460"} - url_background_color
{"id":"16","campaign_id":"134625"} - url_background_color
{"id":"16","campaign_id":"139652"} - url_background_color
{"id":"16","campaign_id":"142717"} - url_background_color
{"id":"16","campaign_id":"144951"} - url_background_color
{"id":"16","campaign_id":"145406"} - url_background_color
{"id":"16","campaign_id":"146357"} - url_background_color
{"id":"16","campaign_id":"154768"} - url_background_color
{"id":"16","campaign_id":"228362"} - url_background_color
{"id":"16","campaign_id":"232311"} - url_background_color
{"id":"16","campaign_id":"243892"} - url_background_color
{"id":"16","campaign_id":"249836"} - url_background_color
{"id":"16","campaign_id":"250043"} - url_background_color
{"id":"16","campaign_id":"250320"} - url_background_color
{"id":"16","campaign_id":"251078"} - url_background_color
{"id":"17","campaign_id":"30942"} - url_background_color
{"id":"17","campaign_id":"64939"} - url_background_color
{"id":"17","campaign_id":"123129"} - url_background_color
{"id":"17","campaign_id":"130614"} - url_background_color
{"id":"17","campaign_id":"136380"} - url_background_color
{"id":"17","campaign_id":"139652"} - url_background_color
{"id":"17","campaign_id":"142717"} - url_background_color
{"id":"17","campaign_id":"144951"} - url_background_color
{"id":"17","campaign_id":"148545"} - url_background_color
{"id":"17","campaign_id":"149156"} - url_background_color
{"id":"17","campaign_id":"152341"} - url_background_color
{"id":"17","campaign_id":"154768"} - url_background_color
{"id":"17","campaign_id":"161340"} - url_background_color
{"id":"17","campaign_id":"187127"} - url_background_color
{"id":"17","campaign_id":"210170"} - url_background_color
{"id":"17","campaign_id":"214684"} - url_background_color
{"id":"17","campaign_id":"229003"} - url_background_color
{"id":"17","campaign_id":"232311"} - url_background_color
{"id":"17","campaign_id":"243892"} - url_background_color
{"id":"18","campaign_id":"57569"} - url_background_color
{"id":"18","campaign_id":"64939"} - url_background_color
{"id":"18","campaign_id":"134659"} - url_background_color
{"id":"18","campaign_id":"142717"} - url_background_color
{"id":"18","campaign_id":"145406"} - url_background_color
{"id":"18","campaign_id":"149156"} - url_background_color
{"id":"18","campaign_id":"154219"} - url_background_color
{"id":"18","campaign_id":"154962"} - url_background_color
{"id":"18","campaign_id":"210170"} - url_background_color
{"id":"18","campaign_id":"214684"} - url_background_color
{"id":"18","campaign_id":"228362"} - url_background_color
{"id":"18","campaign_id":"232311"} - url_background_color
{"id":"18","campaign_id":"236635"} - url_background_color
{"id":"18","campaign_id":"243892"} - url_background_color
{"id":"18","campaign_id":"249836"} - url_background_color
{"id":"18","campaign_id":"250043"} - url_background_color
{"id":"19","campaign_id":"28471"} - url_background_color
{"id":"19","campaign_id":"128871"} - url_background_color
{"id":"19","campaign_id":"145406"} - url_background_color
{"id":"19","campaign_id":"148545"} - url_background_color
{"id":"19","campaign_id":"154768"} - url_background_color
{"id":"19","campaign_id":"154962"} - url_background_color
{"id":"19","campaign_id":"210170"} - url_background_color
{"id":"19","campaign_id":"214684"} - url_background_color
{"id":"19","campaign_id":"229003"} - url_background_color
{"id":"19","campaign_id":"236635"} - url_background_color
{"id":"19","campaign_id":"243892"} - url_background_color
{"id":"19","campaign_id":"249836"} - url_background_color
{"id":"19","campaign_id":"250043"} - url_background_color
{"id":"20","campaign_id":"28471"} - url_background_color
{"id":"20","campaign_id":"30942"} - url_background_color
{"id":"20","campaign_id":"57569"} - url_background_color
{"id":"20","campaign_id":"68794"} - url_background_color
{"id":"20","campaign_id":"236635"} - url_background_color
{"id":"20","campaign_id":"243892"} - url_background_color
{"id":"20","campaign_id":"250043"} - url_background_color
{"id":"21","campaign_id":"28471"} - url_background_color
{"id":"21","campaign_id":"30942"} - url_background_color
{"id":"21","campaign_id":"136695"} - url_background_color
{"id":"21","campaign_id":"145353"} - url_background_color
{"id":"21","campaign_id":"145406"} - url_background_color
{"id":"21","campaign_id":"148545"} - url_background_color
{"id":"21","campaign_id":"183621"} - url_background_color
{"id":"21","campaign_id":"210170"} - url_background_color
{"id":"21","campaign_id":"224111"} - url_background_color
{"id":"21","campaign_id":"243892"} - url_background_color
{"id":"21","campaign_id":"245003"} - url_background_color
{"id":"21","campaign_id":"250043"} - url_background_color
{"id":"22","campaign_id":"28471"} - url_background_color
{"id":"22","campaign_id":"69381"} - url_background_color
{"id":"22","campaign_id":"145406"} - url_background_color
{"id":"22","campaign_id":"232311"} - url_background_color
{"id":"22","campaign_id":"241527"} - url_background_color
{"id":"22","campaign_id":"243892"} - url_background_color
{"id":"22","campaign_id":"245003"} - url_background_color
{"id":"22","campaign_id":"251078"} - url_background_color
{"id":"23","campaign_id":"69381"} - url_background_color
{"id":"23","campaign_id":"116199"} - url_background_color
{"id":"23","campaign_id":"142717"} - url_background_color
{"id":"23","campaign_id":"148545"} - url_background_color
{"id":"23","campaign_id":"154219"} - url_background_color
{"id":"23","campaign_id":"232311"} - url_background_color
{"id":"23","campaign_id":"243892"} - url_background_color
{"id":"23","campaign_id":"245003"} - url_background_color
{"id":"23","campaign_id":"250043"} - url_background_color
{"id":"24","campaign_id":"30942"} - url_background_color
{"id":"24","campaign_id":"69381"} - url_background_color
{"id":"24","campaign_id":"136695"} - url_background_color
{"id":"24","campaign_id":"148545"} - url_background_color
{"id":"24","campaign_id":"154219"} - url_background_color
{"id":"24","campaign_id":"158809"} - url_background_color
{"id":"24","campaign_id":"172319"} - url_background_color
{"id":"24","campaign_id":"232311"} - url_background_color
{"id":"24","campaign_id":"243892"} - url_background_color
{"id":"24","campaign_id":"245003"} - url_background_color
{"id":"24","campaign_id":"250043"} - url_background_color
{"id":"24","campaign_id":"251078"} - url_background_color
{"id":"25","campaign_id":"28471"} - url_background_color
{"id":"25","campaign_id":"144531"} - url_background_color
{"id":"25","campaign_id":"183621"} - url_background_color
{"id":"25","campaign_id":"207542"} - url_background_color
{"id":"25","campaign_id":"227349"} - url_background_color
{"id":"25","campaign_id":"228362"} - url_background_color
{"id":"25","campaign_id":"232311"} - url_background_color
{"id":"25","campaign_id":"241527"} - url_background_color
{"id":"25","campaign_id":"243892"} - url_background_color
{"id":"25","campaign_id":"245003"} - url_background_color
{"id":"26","campaign_id":"28471"} - url_background_color
{"id":"26","campaign_id":"69256"} - url_background_color
{"id":"26","campaign_id":"151575"} - url_background_color
{"id":"26","campaign_id":"207542"} - url_background_color
{"id":"26","campaign_id":"227271"} - url_background_color
{"id":"26","campaign_id":"243892"} - url_background_color
{"id":"27","campaign_id":"69381"} - url_background_color
{"id":"27","campaign_id":"207542"} - url_background_color
{"id":"27","campaign_id":"227271"} - url_background_color
{"id":"27","campaign_id":"228362"} - url_background_color
{"id":"27","campaign_id":"243892"} - url_background_color
{"id":"28","campaign_id":"28471"} - url_background_color
{"id":"28","campaign_id":"69256"} - url_background_color
{"id":"28","campaign_id":"69381"} - url_background_color
{"id":"28","campaign_id":"148545"} - url_background_color
{"id":"28","campaign_id":"207542"} - url_background_color
{"id":"28","campaign_id":"243892"} - url_background_color
{"id":"29","campaign_id":"30942"} - url_background_color
{"id":"29","campaign_id":"31125"} - url_background_color
{"id":"29","campaign_id":"207542"} - url_background_color
{"id":"29","campaign_id":"227271"} - url_background_color
{"id":"29","campaign_id":"243892"} - url_background_color
{"id":"29","campaign_id":"250043"} - url_background_color
{"id":"30","campaign_id":"94884"} - url_background_color
{"id":"30","campaign_id":"130866"} - url_background_color
{"id":"30","campaign_id":"183621"} - url_background_color
{"id":"30","campaign_id":"207542"} - url_background_color
{"id":"30","campaign_id":"227274"} - url_background_color
{"id":"30","campaign_id":"243892"} - url_background_color
{"id":"30","campaign_id":"250043"} - url_background_color
{"id":"31","campaign_id":"94884"} - url_background_color
{"id":"31","campaign_id":"115800"} - url_background_color
{"id":"31","campaign_id":"136695"} - url_background_color
{"id":"31","campaign_id":"148545"} - url_background_color
{"id":"31","campaign_id":"227262"} - url_background_color
{"id":"31","campaign_id":"227271"} - url_background_color
{"id":"31","campaign_id":"250043"} - url_background_color
{"id":"32","campaign_id":"46723"} - url_background_color
{"id":"32","campaign_id":"94884"} - url_background_color
{"id":"32","campaign_id":"136695"} - url_background_color
{"id":"32","campaign_id":"148545"} - url_background_color
{"id":"32","campaign_id":"183621"} - url_background_color
{"id":"32","campaign_id":"187796"} - url_background_color
{"id":"32","campaign_id":"227271"} - url_background_color
{"id":"33","campaign_id":"46249"} - url_background_color
{"id":"33","campaign_id":"46571"} - url_background_color
{"id":"33","campaign_id":"52223"} - url_background_color
{"id":"33","campaign_id":"69381"} - url_background_color
{"id":"33","campaign_id":"94884"} - url_background_color
{"id":"33","campaign_id":"136695"} - url_background_color
{"id":"33","campaign_id":"148545"} - url_background_color
{"id":"33","campaign_id":"153745"} - url_background_color
{"id":"33","campaign_id":"187796"} - url_background_color
{"id":"33","campaign_id":"241527"} - url_background_color
{"id":"34","campaign_id":"30942"} - url_background_color
{"id":"34","campaign_id":"69381"} - url_background_color
{"id":"34","campaign_id":"136695"} - url_background_color
{"id":"34","campaign_id":"183621"} - url_background_color
{"id":"34","campaign_id":"229685"} - url_background_color
{"id":"35","campaign_id":"115800"} - url_background_color
{"id":"35","campaign_id":"136695"} - url_background_color
{"id":"35","campaign_id":"153745"} - url_background_color
{"id":"35","campaign_id":"183621"} - url_background_color
{"id":"35","campaign_id":"204553"} - url_background_color
{"id":"35","campaign_id":"222403"} - url_background_color
{"id":"35","campaign_id":"229684"} - url_background_color
{"id":"36","campaign_id":"29762"} - url_background_color
{"id":"36","campaign_id":"69381"} - url_background_color
{"id":"36","campaign_id":"94884"} - url_background_color
{"id":"36","campaign_id":"136695"} - url_background_color
{"id":"37","campaign_id":"94884"} - url_background_color
{"id":"37","campaign_id":"115800"} - url_background_color
{"id":"37","campaign_id":"136695"} - url_background_color
{"id":"37","campaign_id":"183621"} - url_background_color
{"id":"37","campaign_id":"210053"} - url_background_color
{"id":"38","campaign_id":"69381"} - url_background_color
{"id":"38","campaign_id":"136695"} - url_background_color
{"id":"38","campaign_id":"183621"} - url_background_color
{"id":"39","campaign_id":"28471"} - url_background_color
{"id":"39","campaign_id":"69381"} - url_background_color
{"id":"39","campaign_id":"183621"} - url_background_color
{"id":"40","campaign_id":"28471"} - url_background_color
{"id":"40","campaign_id":"145353"} - url_background_color
{"id":"40","campaign_id":"183621"} - url_background_color
{"id":"41","campaign_id":"28471"} - url_background_color
{"id":"41","campaign_id":"69381"} - url_background_color
{"id":"42","campaign_id":"28471"} - url_background_color
{"id":"42","campaign_id":"96861"} - url_background_color
{"id":"42","campaign_id":"140101"} - url_background_color
{"id":"42","campaign_id":"183621"} - url_background_color
{"id":"42","campaign_id":"204305"} - url_background_color
{"id":"43","campaign_id":"134625"} - url_background_color
{"id":"44","campaign_id":"61160"} - url_background_color
{"id":"44","campaign_id":"134625"} - url_background_color
{"id":"45","campaign_id":"61160"} - url_background_color
{"id":"45","campaign_id":"136830"} - url_background_color
{"id":"45","campaign_id":"145353"} - url_background_color
{"id":"46","campaign_id":"136830"} - url_background_color
{"id":"46","campaign_id":"145353"} - url_background_color
{"id":"47","campaign_id":"29762"} - url_background_color
{"id":"47","campaign_id":"134625"} - url_background_color
{"id":"47","campaign_id":"136830"} - url_background_color
{"id":"47","campaign_id":"183621"} - url_background_color
{"id":"48","campaign_id":"145353"} - url_background_color
{"id":"48","campaign_id":"183621"} - url_background_color
{"id":"49","campaign_id":"145353"} - url_background_color
{"id":"49","campaign_id":"191283"} - url_background_color
{"id":"50","campaign_id":"145353"} - url_background_color
{"id":"50","campaign_id":"191283"} - url_background_color
{"id":"51","campaign_id":"145353"} - url_background_color
{"id":"51","campaign_id":"153745"} - url_background_color
{"id":"52","campaign_id":"78707"} - url_background_color
{"id":"52","campaign_id":"145353"} - url_background_color
{"id":"53","campaign_id":"114803"} - url_background_color
{"id":"53","campaign_id":"145353"} - url_background_color
{"id":"53","campaign_id":"191283"} - url_background_color
{"id":"54","campaign_id":"138437"} - url_background_color
{"id":"54","campaign_id":"142545"} - url_background_color
{"id":"54","campaign_id":"145353"} - url_background_color
{"id":"54","campaign_id":"155529"} - url_background_color
{"id":"55","campaign_id":"145353"} - url_background_color
{"id":"56","campaign_id":"136380"} - url_background_color
{"id":"56","campaign_id":"155529"} - url_background_color
{"id":"56","campaign_id":"199534"} - url_background_color
{"id":"59","campaign_id":"191283"} - url_background_color
{"id":"60","campaign_id":"190202"} - url_background_color
{"id":"60","campaign_id":"191283"} - url_background_color
{"id":"61","campaign_id":"190202"} - url_background_color
{"id":"62","campaign_id":"190202"} - url_background_color
{"id":"63","campaign_id":"108465"} - url_background_color
{"id":"63","campaign_id":"129444"} - url_background_color
{"id":"64","campaign_id":"26254"} - url_background_color
{"id":"65","campaign_id":"26254"} - url_background_color
{"id":"65","campaign_id":"78707"} - url_background_color
{"id":"65","campaign_id":"140101"} - url_background_color
{"id":"68","campaign_id":"121145"} - url_background_color
{"id":"69","campaign_id":"26254"} - url_background_color
{"id":"69","campaign_id":"129396"} - url_background_color
{"id":"71","campaign_id":"26254"} - url_background_color
{"id":"71","campaign_id":"190202"} - url_background_color
{"id":"72","campaign_id":"163636"} - url_background_color
{"id":"72","campaign_id":"190202"} - url_background_color
{"id":"77","campaign_id":"3228"} - url_background_color
{"id":"77","campaign_id":"43120"} - url_background_color
{"id":"78","campaign_id":"43120"} - url_background_color
{"id":"78","campaign_id":"46249"} - url_background_color
{"id":"81","campaign_id":"140101"} - url_background_color
{"id":"98","campaign_id":"29762"} - url_background_color
{"id":"101","campaign_id":"244959"} - url_background_color
{"id":"103","campaign_id":"244959"} - url_background_color
{"id":"104","campaign_id":"244959"} - url_background_color
{"id":"105","campaign_id":"244959"} - url_background_color
{"id":"108","campaign_id":"244959"} - url_background_color
{"id":"109","campaign_id":"244959"} - url_background_color
{"id":"110","campaign_id":"153645"} - url_background_color
{"id":"111","campaign_id":"153645"} - url_background_color
{"id":"111","campaign_id":"244959"} - url_background_color
{"id":"112","campaign_id":"244959"} - url_background_color
{"id":"113","campaign_id":"244959"} - url_background_color
{"id":"116","campaign_id":"244959"} - url_background_color
{"id":"119","campaign_id":"153645"} - url_background_color
{"id":"119","campaign_id":"244959"} - url_background_color
{"id":"149","campaign_id":"131559"} - url_background_color
{"id":"226","campaign_id":"29762"} - url_background_color
