#!/usr/bin/perl

# Нужно настроить базу, БК, Баланс на прод

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use Pod::Usage;
use Getopt::Long qw();

use qbit;
use Application;

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

my $REJECTED = 512;

my $PAGE_MODELS = [qw(context_on_site_campaign search_on_site_campaign)];

my @PAGE_FIELDS = qw(id page_id multistate caption domain_id);

my $FIX = {
    site_is_approved_page_is_need_approve => {
        rus_name    => 'Сайт утвержден, площадка на модерации',
        site_status => 'approved',
        page_fields => sub {
            my @fields = qw(client_id domain mobile_app_mode);

            if ($_[0] eq 'context_on_site_campaign') {
                push(
                    @fields, qw(fast_context
                      only_picture
                      business_unit
                      reload_timeout)
                    );
            }

            return @fields;
        },
        page_status => 'need_approve',
        models      => $PAGE_MODELS,
        process     => sub {
            my $app = shift(@_);
            my ($name, $model, $page) = @_;

            unless ($page->{'page_id'}) {
                _log(@_);

                $app->$model->do_action($page, 'approve', %$page);
            } else {
                _need_see(@_);
            }
          }
    },
    site_is_approved_page_is_rejected => {
        rus_name    => 'Сайт утвержден, площадка отклонена',
        site_status => 'approved',
        page_status => 'rejected',
        models      => $PAGE_MODELS,
        process     => sub {
            my $app = shift(@_);
            my ($name, $model, $page) = @_;

            unless ($app->$model->check_multistate_flag($page->{'multistate'}, 'working')
                || $app->$model->check_multistate_flag($page->{'multistate'}, 'testing'))
            {
                _log(@_);

                my $new_mltistate = $page->{'multistate'} & ~$REJECTED;

                $app->partner_db->$model->edit($page->{'id'}, {multistate => $new_mltistate});

                $app->$model->do_action($page, 'set_blocked')
                  unless $app->$model->check_multistate_flag($new_mltistate, 'blocked');
            } else {
                _need_see(@_);
            }
          }
    },
    site_is_rejected_page_is_need_approve => {
        rus_name    => 'Сайт отклонен, площадка на модерации',
        site_status => 'rejected',
        page_status => 'need_approve',
        models      => $PAGE_MODELS,
        process     => sub {
            my $app = shift(@_);
            my ($name, $model, $page) = @_;

            unless ($app->$model->check_multistate_flag($page->{'multistate'}, 'working')
                || $app->$model->check_multistate_flag($page->{'multistate'}, 'testing'))
            {
                _log(@_);

                $app->$model->do_action($page, 'reject');
            } else {
                _need_see(@_);
            }
          }
    },
    site_is_rejected_page_is_not_rejected => {
        rus_name    => 'Сайт отклонен, площадка не отклонена',
        site_status => 'rejected',
        page_status => 'not rejected',
        models      => $PAGE_MODELS,
        process     => sub {
            my $app = shift(@_);
            my ($name, $model, $page) = @_;

            unless ($app->$model->check_multistate_flag($page->{'multistate'}, 'working')
                || $app->$model->check_multistate_flag($page->{'multistate'}, 'testing'))
            {
                _log(@_);

                if ($app->$model->check_action($page, 'reject')) {
                    $app->$model->do_action($page, 'reject');
                } else {
                    my $new_mltistate = $page->{'multistate'} | $REJECTED;

                    $app->partner_db->$model->edit($page->{'id'}, {multistate => $new_mltistate});
                }
            } else {
                _need_see(@_);
            }
          }
    },
    context_pages_are_blocked_page_is_active => {
        rus_name =>
'Контестные площадки заблокированы на сайте, но есть рабочие',
        site_status => 'context_on_site_campaign_blocked',
        page_status => 'working or testing or need_approve',
        models      => [qw(context_on_site_campaign)],
        process     => sub {
            my $app = shift(@_);
            my ($name, $model, $page) = @_;

            _need_see(@_);
          }
    },
    search_pages_are_blocked_page_is_active => {
        rus_name =>
'Поисковые площадки заблокированы на сайте, но есть рабочие',
        site_status => 'search_on_site_campaign_blocked',
        page_status => 'working or testing or need_approve',
        models      => [qw(search_on_site_campaign)],
        process     => sub {
            my $app = shift(@_);
            my ($name, $model, $page) = @_;

            _need_see(@_);
          }
    },
};

main();

sub main {
    my $app = Application->new();

    $app->pre_run();

    $app->set_cur_user({id => 0});

    my $sites = $app->site->get_all(fields => [qw(id multistate)]);

    foreach my $name (sort keys(%$FIX)) {
        my ($models, $site_status, $page_fields, $page_status, $process) =
          @{$FIX->{$name}}{qw(models site_status page_fields page_status process)};

        foreach my $model (@$models) {
            say "START: $name($model)";

            my @site_ids =
              map {$_->{'id'}} grep {$app->site->check_multistate_flag($_->{'multistate'}, $site_status)} @$sites;

            my $pages = $app->$model->get_all(
                fields => [@PAGE_FIELDS, $page_fields ? $page_fields->($model) : ()],
                filter => {domain_id => \@site_ids, multistate => $page_status}
            );

            foreach my $page (@$pages) {
                $process->($app, $name, $model, $page);
            }

            say "END: $name($model)";
        }
    }

    $app->post_run();

    say '#END';
}

sub _log {
    my ($name, $model, $page) = @_;

    say "LOG: $model: " . to_json($page);
}

sub _need_see {
    my ($name, $model, $page) = @_;

    say "NEED SEE: $FIX->{$name}{'rus_name'} ($model): " . to_json($page);
}
