#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

use File::Temp qw(tempfile tempdir);

sub _datetime_for_key {
    my ($dt) = @_;

    $dt =~ s/:/-/g;
    $dt =~ s/\s/_/g;

    return $dt;
}

sub main {
    my $app = Application->new();
    $app->pre_run();

    my $user_id = 0;
    $app->set_cur_user({id => $user_id});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $first_day = ($ARGV[0] // '2015-04') . '-01';
    my $stop = date_add(($ARGV[1] // '2017-09') . '-01', month => 1, iformat => 'db', oformat => 'db');
    while ($first_day ne $stop) {

        my $last_day = trdate(db => norm => $first_day);
        $last_day->[2] = trdate(norm => days_in_month => $last_day);
        $last_day = trdate(norm => db => $last_day);

        say "START $first_day - $last_day";

        for my $date (dates2array($first_day, $last_day, iformat => 'db', oformat => 'db')) {
            my $tmp_path = (tempfile(DIR => $app->get_option('tmp_dir')))[1];

            $app->api_http_bk->get_publisher_stat(
                startdate       => $date,
                stopdate        => $date,
                ':content_file' => $tmp_path,
            );

            $app->stat_download_data->cache_http_data(
                method            => 'get_publisher_stat',
                date              => $date,
                path              => $tmp_path,
                remove_end_marker => "#END\n",
            );
        }

        $app->video_stat_files->generate_publisher_reports($first_day, $last_day);

        $app->stat_download_data->delete_cached_data(
            [AND => [[stat_date => '>=' => $first_day], [stat_date => '<=' => $last_day]]]);

        say "END $first_day - $last_day";

        $first_day = date_add($first_day, month => 1, iformat => 'db', oformat => 'db');
    }

    say '#END';
}
main();
__END__
