#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

use File::Slurp;
use Compress::Zlib qw(uncompress);
use File::Temp qw(tempfile tempdir);
use Archive::Zip qw(AZ_OK);
use File::stat;

use Exception::StatFiles;

sub _datetime_for_key {
    my ($dt) = @_;

    $dt =~ s/:/-/g;
    $dt =~ s/\s/_/g;

    return $dt;
}

sub main {
    my $app = Application->new();
    $app->pre_run();

    my $user_id = 0;
    $app->set_cur_user({id => $user_id});

    my $xls_files = $app->partner_db->_get_all('
        SELECT id, page_id, from_date, to_date, modification_date, data
        FROM video_stat_files
        WHERE s3_key IS NULL
    ');

    my $dir = tempdir('PI-10055_xls_files_XXXXX', DIR => './');

    for my $xls (@$xls_files) {
        my $filename = "$xls->{page_id}_$xls->{from_date}_$xls->{to_date}.xls";
        write_file("$dir/$filename", uncompress(substr($xls->{data}, 4, length($xls->{data}) - 1)));
        try {
            my $archive_filename = $app->video_stat_files->_create_archive("$dir/$filename" => $filename);

            my $curdate        = curdate(oformat => 'db_time');
            my $rand           = int(rand(1000000));
            my $mod_dt_for_key = _datetime_for_key($xls->{modification_date});
            my $key            = "$xls->{page_id}_$xls->{from_date}_$xls->{to_date}_${mod_dt_for_key}_${rand}.zip";

            $app->api_media_storage_s3->put($key, $archive_filename);

            my $size = stat($archive_filename)->size;

            $app->partner_db->_do("
                UPDATE video_stat_files
                SET s3_key  = '$key',
                    s3_size = $size
                WHERE id   = $xls->{id};
            ");

            say $key;
        }
        catch Exception::StatFiles with {
            say shift->message;
        };
    }

    my ($dir_archive_fh, $dir_archive_filename) = tempfile('PI-10055_xls_reports_XXXXXX');

    my $zip = Archive::Zip->new();
    $zip->addTree($dir, 'xls_backup');
    unless ($zip->writeToFileHandle($dir_archive_fh) == AZ_OK) {
        die "Failed to create zip archive $dir_archive_filename with $dir";
    }
    close($dir_archive_fh) or die "close: $!";

    system('mv', $dir_archive_filename, "$dir_archive_filename.zip");

    say "dir archive: $dir_archive_filename.zip";

    $app->post_run();
    say "#END";
}
main();
__END__
