#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

use SQL::Easy;

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {TRUE};
    }

    my $se = SQL::Easy->new({dbh => $app->partner_db->get_dbh(),});

    my $today = name2date('today', oformat => 'norm');
    $today->[2] = 1;
    my $dt = trdate('norm' => 'db' => $today);    #First day of current month
    my $tomorrow = name2date('tomorrow', oformat => 'db');

    while ($dt ne $tomorrow) {
        for my $type (qw(adfox rtb)) {
            say "$dt $type";
            $se->execute("
                INSERT INTO statistics_context_on_site_rtb__adfox_migration_copy (
                dt,
                campaign_id,
                block_id,
                dsp_id,
                currency_id,
                tag_id,
                rtb_block_shows,
                rtb_block_shows_own_adv,
                rtb_block_hits,
                rtb_block_hits_own_adv,
                rtb_block_hits_unsold,
                rtb_block_direct_clicks,
                rtb_block_direct_shows,
                rtb_all_w_nds,
                rtb_all_wo_nds,
                all_w_nds,
                all_wo_nds,
                rtb_partner_w_nds,
                rtb_partner_wo_nds,
                partner_w_nds,
                partner_wo_nds,
                rtb_block_bad_shows,
                rtb_block_bad_shows_own_adv,
                rtb_block_bad_win_hits,
                rtb_block_bad_win_hits_own_adv,
                rtb_block_bad_win_hits_unsold,
                rtb_bad_win_price_w_nds,
                rtb_bad_win_price_wo_nds,
                bad_win_price_w_nds,
                bad_win_price_wo_nds,
                rtb_bad_win_partner_price_w_nds,
                rtb_bad_win_partner_price_wo_nds,
                bad_win_partner_price_w_nds,
                bad_win_partner_price_wo_nds
                )
                SELECT
                dt,
                campaign_id,
                block_id,
                dsp_id,
                currency_id,
                tag_id,
                ${type}_block_shows,
                ${type}_block_shows_own_adv,
                ${type}_block_hits,
                ${type}_block_hits_own_adv,
                ${type}_block_hits_unsold,
                ${type}_block_direct_clicks,
                ${type}_block_direct_shows,
                ${type}_all_w_nds,
                ${type}_all_wo_nds,
                all_w_nds,
                all_wo_nds,
                ${type}_partner_w_nds,
                ${type}_partner_wo_nds,
                partner_w_nds,
                partner_wo_nds,
                ${type}_block_bad_shows,
                ${type}_block_bad_shows_own_adv,
                ${type}_block_bad_win_hits,
                ${type}_block_bad_win_hits_own_adv,
                ${type}_block_bad_win_hits_unsold,
                ${type}_bad_win_price_w_nds,
                ${type}_bad_win_price_wo_nds,
                bad_win_price_w_nds,
                bad_win_price_wo_nds,
                ${type}_bad_win_partner_price_w_nds,
                ${type}_bad_win_partner_price_wo_nds,
                bad_win_partner_price_w_nds,
                bad_win_partner_price_wo_nds
                FROM statistics_context_on_site_${type}
                WHERE dt = '$dt'
            ");

            sleep(1);
        }

        $dt = date_add($dt, day => 1, iformat => 'db', oformat => 'db');
    }

    say "#END\n";

    $app->post_run();
}
main();
__END__
