#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;
use warnings;
use strict;

# project modules
use lib::abs qw(
  ./lib
  );
use qbit;
use Application;

# global vars

# subs

# main
use DDP;

sub main {
    my $app = Application->new();
    $app->pre_run();

    my $yndx_bessarabov_user_id = 155209804;
    $app->set_cur_user({id => $yndx_bessarabov_user_id});

    # check mocked
    {
        no strict 'refs';
        no warnings 'redefine';
        local *{'Application::Model::Documents::get_raw_contracts'} = sub {
            my @data = <DATA>;
            return from_json(join('', @data));
        };

        my %opts = (
            client_id => '34331241',
            login     => 'montana-group-2017',
        );

        p $app->documents->get_active_contract(\%opts);
    }

    $app->post_run();
    say "#END";
}
main();
__DATA__
[
   {
      "Person":{
         "tax_type":"",
         "legal_address_town":"",
         "fname":"Нурлан ",
         "address_postcode":"127473",
         "person_account":"",
         "email":"fin@montan.ru",
         "address_district":"",
         "ben_account":"",
         "legaladdress":"127473, г Москва, Щемиловский 2-й пер, д 4, стр 1",
         "passport_code":"",
         "address_street":"Щемиловский 2-й пер",
         "birthplace_region":"",
         "is_partner":"1",
         "fias_guid":"0c5b2444-70a0-4932-980c-b4dc0d3f02b5",
         "address_home":"4",
         "region":"225",
         "name":"Монтана Групп",
         "kpp":"770701001",
         "signer_person_gender":"",
         "ogrn":"",
         "bank":"ПАО СБЕРБАНК",
         "legal_address_district":"",
         "lname":"Наджафов ",
         "live_signature":"0",
         "jpc":"",
         "kz_kbe":"",
         "mname":"Хамис Оглы",
         "postaddress_envelope":"Щемиловский 2-й пер, д 4, стр 1\nг Москва",
         "passport_s":"",
         "kz_in":"",
         "address_town":"",
         "pfr":"",
         "address_updated":"",
         "fax":"",
         "birthday":"",
         "organization":"",
         "birthplace_country":"",
         "legal_address_home":"4",
         "account":"40702810138090005939",
         "postaddress":"Москва г, Щемиловский 2-й пер, 4стр1",
         "client_id":"34331241",
         "revise_act_period_type":"",
         "bankcity":"МОСКВА",
         "address_code":"770000000000622",
         "iban":"",
         "birthplace_district":"",
         "legal_address_postcode":"127473",
         "delivery_type":"0",
         "iik":"",
         "address_construction":"1",
         "street":"",
         "legal_address_region":"Москва г",
         "inn_doc_details":"",
         "rnn":"",
         "passport_e":"",
         "longname":"ООО «Монтана Групп»",
         "delivery_city":"",
         "authority_doc_type":"Устав",
         "address_city":"",
         "id":"4445573",
         "corraccount":"",
         "address":"127473, Москва г, Щемиловский 2-й пер, 4стр1",
         "ben_bank":"",
         "legal_address_building":"",
         "legal_address_flat":"",
         "address_building":"",
         "passport_n":"",
         "authority_doc_details":"",
         "address_region":"Москва г",
         "bik":"044525225",
         "_kladr_code":"",
         "other":"",
         "signer_position_name":"Генерального директора",
         "passport_d":"",
         "type":"ur",
         "address_gni":"7707",
         "legal_address_gni":"7707",
         "bank_inn":"",
         "signer_person_name":"Наджафова Нурлана Хамиса Оглы",
         "dt":"2017-07-18",
         "postsuffix":"Щемиловский 2-й пер, д 4, стр 1",
         "legal_address_code":"770000000000622",
         "city":"г Москва",
         "us_state":"",
         "bank_type":"0",
         "representative":"Елена Ткач",
         "postcode":"127473",
         "swift":"",
         "rn":"",
         "invalid_address":"0",
         "memo":"",
         "phone":"+7 (495) 645-07-50",
         "legal_address_city":"",
         "legal_address_street":"Щемиловский 2-й пер",
         "yamoney_wallet":"",
         "inn":"7707729591",
         "address_flat":"",
         "legal_address_construction":"1",
         "vat_payer":"",
         "hidden":"0"
      },
      "Client":{
         "overdraft_limit":"",
         "reliable_cc_payer":"0",
         "client_type_id":"0",
         "email":"montana.group.2017@yandex.ru",
         "deny_cc":"0",
         "region_id":"",
         "url":"",
         "full_repayment":"1",
         "id":"34331241",
         "aux_is_docs_separated":"0",
         "manual_discount":"0",
         "subregion_id":"",
         "name":"«Монтана Групп»",
         "direct25":"0",
         "manual_suspect":"0",
         "manual_suspect_comment":"",
         "partner_type":"1",
         "dt":"2017-07-18",
         "agency_id":"",
         "is_non_resident":"0",
         "iso_currency_payment":"",
         "budget":"0",
         "domain_check_status":"0",
         "city":"",
         "is_agency":"0",
         "fax":"",
         "overdraft_ban":"0",
         "internal":"0",
         "suspect":"0",
         "creation_dt":"2017-07-18",
         "phone":"+74956450750",
         "aux_is_docs_detailed":"0",
         "currency_payment":"",
         "domain_check_comment":"",
         "fullname":"",
         "class_id":"34331241",
         "is_wholesaler":""
      },
      "Collaterals":[
         {
            "is_faxed":"",
            "num":"",
            "dt":"2017-07-19",
            "is_cancelled":"",
            "memo":"Баранвоская\n170908-00465",
            "sent_dt":"",
            "contract2_id":"291636",
            "create_dt":"2017-09-11",
            "update_dt":"2017-09-11",
            "collateral_type_id":"2100",
            "is_signed":"",
            "id":"365868",
            "class":"ANNOUNCEMENT",
            "nds":"0"
         }
      ],
      "Contract":{
         "is_faxed":"2017-07-21",
         "atypical_conditions":"0",
         "manager_code":"20468",
         "pay_to":"1",
         "payment_type":"1",
         "open_date":"0",
         "collateral_type_id":"",
         "unilateral_acts":"0",
         "id":"331983",
         "doc_set":"",
         "person_id":"4445573",
         "sent_dt":"2017-08-02",
         "external_id":"РС-56392-07/17",
         "market_api_pct":"50",
         "type":"PARTNERS",
         "partner_pct":"43",
         "num":"",
         "search_forms":"0",
         "is_cancelled":"",
         "dt":"2017-07-18",
         "reward_type":"1",
         "currency":"643",
         "market_banner":"0",
         "contract2_id":"291636",
         "create_dt":"2017-07-18",
         "contract_type":"6",
         "firm":"1",
         "client_id":"34331241",
         "memo":"Полякова\n\n 170718-00877",
         "update_dt":"2017-07-25",
         "is_signed":"2017-07-25",
         "end_dt":"",
         "nds":"18",
         "is_booked":"0"
      }
   }
]
