#!/bin/bash

export YT_HOME=//home/zurom

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

################## Constants

YT_META_CLUSTER='markov'
YT_REPLICA_CLUSTER_1='hahn'
YT_REPLICA_CLUSTER_2='banach'

YT_PROJECT_PATH='//home/partner'
YT_TABLE_PATH_OLD="${YT_PROJECT_PATH}/business_rules_2"
YT_TABLE_PATH_NEW="${YT_PROJECT_PATH}/business_rules"
YT_TABLE_SCHEMA='[{name=page_id;type=uint64;sort_order=ascending};{name=block_id;type=uint64;sort_order=ascending};{name=data;type=string}]'



################## удаляем старые таблицы

# Удаляем старый business_rules_2

yt remove $YT_TABLE_PATH_OLD --proxy $YT_REPLICA_CLUSTER_1 2>/dev/null || true
yt remove $YT_TABLE_PATH_OLD --proxy $YT_REPLICA_CLUSTER_2 2>/dev/null || true
yt remove $YT_TABLE_PATH_OLD --proxy $YT_META_CLUSTER      2>/dev/null || true

# Удаляем старый business_rules

yt remove $YT_TABLE_PATH_NEW --proxy $YT_REPLICA_CLUSTER_1
yt remove $YT_TABLE_PATH_NEW --proxy $YT_REPLICA_CLUSTER_2
yt remove $YT_TABLE_PATH_NEW --proxy $YT_META_CLUSTER


# Смотрим что осталось
# yt list $YT_PROJECT_PATH --proxy $YT_REPLICA_CLUSTER_1
# yt list $YT_PROJECT_PATH --proxy $YT_REPLICA_CLUSTER_2
# yt list $YT_PROJECT_PATH --proxy $YT_META_CLUSTER



################## заводим таблицы


REPLICATED_TABLE_ID=$(\
    yt create replicated_table $YT_TABLE_PATH_NEW --attr "{
      dynamic=%true;
      schema=$YT_TABLE_SCHEMA
    }"  --proxy $YT_META_CLUSTER
); echo $REPLICATED_TABLE_ID

 # 7f43-899c-3f301a9-882d90c



# Создаем реплику, смотрящую на кластер Freud
REPLICA_ID_ClUSTER_1=$( \
    yt create table_replica --attr "{
        table_path=\"$YT_TABLE_PATH_NEW\";
        cluster_name=$YT_REPLICA_CLUSTER_1;
        replica_path=\"$YT_TABLE_PATH_NEW\"
    }" --proxy $YT_META_CLUSTER
); echo $REPLICA_ID_ClUSTER_1

# 7f43-b5fa-3f302c5-40c36


# Вторую реплику заведем на кластере Hume
REPLICA_ID_ClUSTER_2=$( \
    yt create table_replica --attr "{
        table_path=\"$YT_TABLE_PATH_NEW\";
        cluster_name=$YT_REPLICA_CLUSTER_2;
        replica_path=\"$YT_TABLE_PATH_NEW\"
    }" --proxy $YT_META_CLUSTER
); echo $REPLICA_ID_ClUSTER_2

# 7f43-bae4-3f302c5-39fd0f3c




# Теперь заведем на Freud саму таблицу-реплику.
TABLE_ID_1=$( \
    yt create table $YT_TABLE_PATH_NEW --attr "{
       dynamic=%true;
       upstream_replica_id=\"$REPLICA_ID_ClUSTER_1\";
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER_1
); echo $TABLE_ID_1

# bd03-1734-3f40191-22506173


# И аналогично сделаем таблицу-реплику на Freud.
# Теперь заведем на Hume саму таблицу-реплику.
TABLE_ID_2=$( \
    yt create table $YT_TABLE_PATH_NEW --attr "{
       dynamic=%true;
       upstream_replica_id=\"$REPLICA_ID_ClUSTER_2\";
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER_2
); echo $TABLE_ID_2

# ab3b-b02d-3ff0191-c9193a2



# Примонтируем таблицы-реплики и реплицированную таблицу.
yt mount-table   $YT_TABLE_PATH_NEW    --proxy $YT_META_CLUSTER
yt mount-table   $YT_TABLE_PATH_NEW    --proxy $YT_REPLICA_CLUSTER_1
yt mount-table   $YT_TABLE_PATH_NEW    --proxy $YT_REPLICA_CLUSTER_2



# Мы забыли включить реплики. Сделаем это.
yt alter-table-replica "$REPLICA_ID_ClUSTER_1" --enable --mode async  --proxy $YT_META_CLUSTER
yt alter-table-replica "$REPLICA_ID_ClUSTER_2" --enable --mode async  --proxy $YT_META_CLUSTER


exit 0;


############# Проверяем

# Попробуем записать в реплицированную таблицу (--no-require-sync-replica !!)
echo '{page_id=0;block_id=0;data="{}"}' | yt insert-rows $YT_TABLE_PATH_NEW --format yson --no-require-sync-replica --proxy $YT_META_CLUSTER

yt select "* from [$YT_TABLE_PATH_NEW]" --format json --proxy $YT_REPLICA_CLUSTER_1


echo '{"page_id":0,"block_id":0,"data":"{\"page_imp\":[{\"page_id\":0,\"imp_id\":0}],\"rules\":[{\"rule_id\":0,\"context\":[[[\"reg-id\",\"equal\",\"213\"],[\"reg-id\",\"equal\",\"2\"]],[[\"detailed-device-type\",\"equal\",\"3\"]]],\"min_cpm\":10.23}]}"}' \
  | yt insert-rows $YT_TABLE_PATH_NEW --format json --no-require-sync-replica --proxy $YT_META_CLUSTER

echo '{page_id=0;block_id=0}' \
  | yt delete-rows $YT_TABLE_PATH_NEW --format yson --no-require-sync-replica --proxy $YT_META_CLUSTER


# Проверим, что данные успешно реплицируются.
yt select "* from [$YT_TABLE_PATH_NEW]" --format json --proxy $YT_REPLICA_CLUSTER_1
yt select "* from [$YT_TABLE_PATH_NEW]" --format json --proxy $YT_REPLICA_CLUSTER_2
