#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

    нужно подключить прод базу

=head1 USAGE

    ./bin/oneshots/PI-10617_exclude_cretated_auto_moderation_requests.pl --dry_run
    ./bin/oneshots/PI-10617_exclude_cretated_auto_moderation_requests.pl --limit=3


=head1 OPTIONS

  dry_run - Ничего неудаляет, просто выводит то что хочет удалить
  limit   - отбрабатывает только первые N зеркал

=cut

use strict;
use warnings;
use feature 'say';

use Getopt::Long qw();
use Pod::Usage;

use lib::abs qw(../../lib);
use qbit;
use Application;
use Utils::Logger qw/ INFOF /;

main();

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0, login => 'system-cron'});

    no strict 'refs';
    no warnings 'redefine';
    local *{'QBit::Application::check_rights'} = sub {TRUE};

    my ($is_dry_run, $limit) = _get_args();

    delete_moderation_requests($app, $is_dry_run, $limit);

    $app->post_run();
}

sub delete_moderation_requests {
    my ($app, $is_dry_run, $limit) = @_;

    my %page_ids = ();

    foreach my $accessor (qw(context_on_site_mirrors search_on_site_mirrors)) {

        INFOF('Start process %s', $accessor);

        my $query = $app->partner_db->query->select(
            table  => $app->partner_db->$accessor,
            alias  => 'M',
            fields => [qw(id campaign_id)],
            filter => {'auto' => 1},
          )->join(
            table   => $app->partner_db->baddomains_exclude,
            alias   => 'D',
            fields  => [qw(domain)],
            join_on => ['domain' => '=' => {domain => $app->partner_db->$accessor}]
          )->order_by(qw( campaign_id ));

        $query = $query->limit($limit) if $limit;

        my $excluded_auto_mirrors = $query->get_all();

        my $prev_campaign_id = -1;
        my $count            = 0;
        foreach my $mirror (@$excluded_auto_mirrors) {
            my ($id, $campaign_id, $domain) = @$mirror{qw( id  campaign_id  domain  )};

            INFOF('    %02d. page_id=%s', ++$count, $campaign_id) if $prev_campaign_id != $campaign_id;
            INFOF('        domain=%s, id=%s', $domain, $id);

            my $rels = $app->partner_db->moderation_rel_site_mirrors->get_all(
                fields => [qw(qid)],
                filter => {id => $id}
            );

            $app->partner_db->transaction(
                sub {

                    foreach my $rel (@$rels) {
                        my $qid = $rel->{qid};

                        INFOF('            moderation_rel_site_mirrors (id=%s, qid=%s))', $id, $qid) if $is_dry_run;

                        INFOF('                delete moderation_queue_action_log (elem_id=%s)', $qid) if $is_dry_run;
                        $app->partner_db->moderation_queue_action_log->delete(
                            $app->partner_db->filter({elem_id => $qid}))
                          unless $is_dry_run;

                        INFOF('                delete moderation_rel_site_mirrors (id=%s, qid=%s)', $id, $qid)
                          if $is_dry_run;
                        $app->partner_db->moderation_rel_site_mirrors->delete(
                            $app->partner_db->filter({id => $id, qid => $qid}))
                          unless $is_dry_run;

                        my $any_other_rels = $app->partner_db->moderation_rel_site_mirrors->get_all(
                            fields => [qw(id)],
                            filter => {qid => $qid}
                        );
                        unless (@$any_other_rels) {
                            INFOF('            delete moderation_queue (id=%s)', $qid) if $is_dry_run;
                            $app->partner_db->moderation_queue->delete($app->partner_db->filter({id => $qid}))
                              unless $is_dry_run;
                        }
                    }

                    INFOF('            delete %s (id=%s)', $accessor, $id) if $is_dry_run;
                    $app->partner_db->$accessor->delete($app->partner_db->filter({id => $id})) unless $is_dry_run;

                }
            );

            $prev_campaign_id = $campaign_id;
        }
    }

    say '#END';
}

sub _get_args {

    my $help       = 0;
    my $is_dry_run = 0;
    my $limit      = undef;

    Getopt::Long::GetOptions(
        #--- Optional
        'dry_run!' => \$is_dry_run,
        'limit:i'  => \$limit,
        #---
        'help|?|h' => \$help,
    ) or pod2usage(1);

    pod2usage(-verbose => 2, -noperldoc => 1) if $help;

    $is_dry_run = 1 if $limit;

    return ($is_dry_run, $limit);
}
