set @JSON='{'
    '"browsers": [2,88],'
    '"regions":  [1, 255],'
    '"systems":  [15,33],'
    '"devices":  ["desktop", "smarttv"],'
    '"urls":     ["http://foo.com", "https://bar.net"],'
    '"query_args" : {"puid1": ["foo", "bar"], "puid63": ["baz"]}'
'}';

set @JSON_ADBLOCK='{'
    '"browsers": [2,88],'
    '"regions":  [1, 255],'
    '"systems":  [15,33],'
    '"devices":  ["desktop", "smarttv"],'
    '"urls":     ["http://foo.com", "https://bar.net"],'
    '"query_args" : {"puid1": ["foo", "bar"], "puid63": ["baz"], "adb_enabled": ["1"]}'
'}';

/* spina001 (R-A-45551-8, D-A-45551-1) */
set @YAN_PARTNER_USER_ID = 13690671;

/* rm-prj (R-A-207848-1,D-A-65055-98)  */
set @ADBLOCK_PARTNER_USER_ID = 105257257;


INSERT INTO business_rules
    (rule_id,  owner_id,                  caption,                                               cpm,   conditions,       multistate,  position,  create_date          ) VALUES
    (10,       @YAN_PARTNER_USER_ID,      'Rule #10 - working (mocked-yan-partner)',             99,    @JSON,            1,           1,         '2017-11-20 08:56:18' ),
    (11,       @YAN_PARTNER_USER_ID,      'Rule #11 - working (mocked-yan-partner)',             19,    @JSON,            1,           2,         '2017-11-20 08:56:18' ),
    (12,       @YAN_PARTNER_USER_ID,      'Rule #12 - stopped (mocked-yan-partner)',             9999,  @JSON,            2,           0,         '2017-11-20 08:56:18' ),
    (13,       @YAN_PARTNER_USER_ID,      'Rule #13 - deleted (mocked-yan-partner)',             29,    @JSON,            6,           0,         '2017-11-20 08:56:18' ),
    (14,       @YAN_PARTNER_USER_ID,      'Rule #14 - working (mocked-yan-partner)',             0,     @JSON,            1,           3,         '2017-11-20 08:56:18' ),
    (15,       @YAN_PARTNER_USER_ID,      'Rule #15 - working (mocked-yan-partner)',             0,     @JSON,            1,           4,         '2017-11-20 08:56:18' ),
    (16,       @YAN_PARTNER_USER_ID,      'Rule #16 - working (mocked-yan-partner)',             0,     @JSON,            1,           5,         '2017-11-20 08:56:18' ),
    (21,       @ADBLOCK_PARTNER_USER_ID,  'Rule #20 - working (mocked-context-adblock-partner)', 99,    @JSON_ADBLOCK,    1,           1,         '2017-11-20 08:56:18' )
    ON DUPLICATE KEY UPDATE owner_id=VALUES(owner_id), caption=VALUES(caption), conditions=VALUES(conditions), multistate=VALUES(multistate), position=VALUES(position);


INSERT INTO business_blocks
    (rule_id,  page_id,  block_id,  block_accessor,           is_deleted,  multistate,   update_time,            send_time              ) VALUES
    (10,       45551,    8,         'context_on_site_rtb',    0,           0,            '2017-12-20 10:01:59',  '2017-12-20 10:05:59'  ),
    (10,       45551,    1,         'context_on_site_direct', 0,           0,            '2017-12-20 10:01:59',  '2017-12-20 10:05:59'  ),
    (21,       207848,   1,         'context_on_site_rtb',    0,           0,            '2017-12-20 10:01:59',  '2017-12-20 10:05:59'  ),
    (21,       65055,    98,        'context_on_site_direct', 0,           0,            '2017-12-20 10:01:59',  '2017-12-20 10:05:59'  ),
    (15,       45551,    8,         'context_on_site_rtb',    0,           1,            '2017-12-20 10:01:59',  '2017-12-20 10:05:59'  ),
    (16,       45551,    1,         'context_on_site_direct', 0,           1,            '2017-12-20 10:01:59',  '2017-12-20 10:05:59'  )
    ON DUPLICATE KEY UPDATE block_accessor=VALUES(block_accessor);
