#!/bin/bash

PATH_CH='/opt/clickhouse.partner';

DATABASE='stat';
USER='default';
TABLE='test';

CLICKHOUSE_ARGUMENTS="-m --user=$USER -d $DATABASE";

clickhouse-client $CLICKHOUSE_ARGUMENTS -q "DETACH TABLE $DATABASE.$TABLE";

PATH_DIR="$PATH_CH/data/$DATABASE/$TABLE";

DIRECTORIES=$(ls -d $PATH_DIR/*/);

for dir in $DIRECTORIES;
do
    if [[ $dir =~ "/detached/" ]]
    then
        continue;
    fi
    echo "move files - $dir";

    mv "$dir/date.bin" "$dir/dt.bin" && mv "$dir/date.mrk" "$dir/dt.mrk"

    echo "remove file - $dir";

    rm "$dir/checksums.txt";
done

PATH_FILE="$PATH_CH/metadata/$DATABASE/$TABLE.sql";

echo "rename date to dt for $PATH_FILE";

sed -i.bak s/date/dt/g "$PATH_FILE";
rm "$PATH_FILE.bak";

clickhouse-client $CLICKHOUSE_ARGUMENTS < "$PATH_FILE";

for dir in $DIRECTORIES;
do
    if [[ $dir =~ "/detached/" ]]
    then
        continue;
    fi

    if [[ $dir =~ ^.*/([0-9]{6})[0-9_]+/$ ]]
    then
        echo "attach - ${BASH_REMATCH[1]}";

        clickhouse-client $CLICKHOUSE_ARGUMENTS -q "ALTER TABLE $DATABASE.$TABLE ATTACH PARTITION ${BASH_REMATCH[1]}";
    fi
done
