#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use File::Slurp;
use File::Temp qw(tempfile);

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    my $google_id = 17298340;
    my @tmpls     = qw(tmpl_ssp_context_rtb tmpl_ssp_mobile_app);

    my $google_data = $app->partner_db->ssp_seller->get($google_id, fields => \@tmpls);

    my %new_values = (
        strategy => \0,
        (map {$_ => undef} (qw(text_active text_blocked text_cpm media_active media_blocked media_cpm))),
    );

    for my $tmpl_name (@tmpls) {
        my $tmpl_data = from_json($google_data->{$tmpl_name});

        my $dump_file_name = (tempfile("${tmpl_name}_before_XXXXXX"))[1];
        write_file($dump_file_name, {binmode => ':utf8'}, $google_data->{$tmpl_name});
        say "Old $tmpl_name saved into $dump_file_name";

        $tmpl_data = {%$tmpl_data, %new_values};

        $google_data->{$tmpl_name} = to_json($tmpl_data, canonical => 1);
    }

    $app->partner_db->ssp_seller->edit($google_id, $google_data);

    my $resend_list_file_name = (tempfile("resend_to_bk_XXXXXX"))[1];
    # PI-10484 модели SSP поменяли свои аксессоры:
    # ssp_context_rtb => ssp_context_on_site_campaign
    # ssp_mobile_app  => ssp_mobile_app_settings
    for my $page_table (qw(ssp_context_rtb ssp_mobile_app)) {
        $app->partner_db->$page_table->edit($app->partner_db->filter({seller_id => $google_id}), \%new_values);
        my $page_ids = $app->partner_db->$page_table->get_all(
            filter => {seller_id => $google_id},
            fields => ['page_id'],
        );
        write_file(
            $resend_list_file_name,
            {append => 1, binmode => ':utf8'},
            join("\n", map {$_->{page_id} // ()} @$page_ids)
        );
    }

    say "./bin/resend_to_bk.pl --file_path=./$resend_list_file_name  2>&1 | tee resend_to_bk.log";

}

main();
