#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

my $chunk_size = 1000;

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $n = 0;
    my $blocks;
    do {

        $blocks = $app->context_on_site_rtb->get_all(
            fields => [qw(campaign_id id horizontal_align)],
            filter => {direct_block => 'extensibleMobile'},
            limit  => $chunk_size,
            offset => $n * $chunk_size,
        );

        say to_json($blocks);

        try {
            $app->partner_db->transaction(
                sub {
                    $app->partner_db->context_on_site_rtb->edit($blocks, {horizontal_align => undef},);
                }
            );
        }
        catch {
            my ($e) = @_;
            say 'ERROR: ' . $e->message;
        };

        $n += 1;

    } while (@$blocks == $chunk_size);

    say '#END';
}

main();
