#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

my @page_ids = (
    263018, 263192, 263881, 263882, 263884, 260228, 260227, 260226, 260225, 260214, 260215, 260223, 259601, 260087,
    260077, 259773, 260002, 259865, 259701, 259864, 259856, 260105, 260103, 261444, 260099, 260229, 260232, 260165,
    260166, 263517, 260167, 260224, 259869, 260230, 260244, 260243, 261452, 261606
);

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    for my $block_model (qw(video_an_site_instream video_an_site_inpage video_an_site_fullscreen)) {
        my $blocks = $app->$block_model->get_all(
            fields => [qw(page_id id multistate strategy mincpm)],
            filter => {page_id => \@page_ids},
        );

        for my $block (@$blocks) {
            print to_json({model => $block_model, %$block}, canonical => 1);

            try {
                if ($block->{strategy} == 0) {
                    if ($app->$block_model->check_multistate_flag($block->{multistate}, 'deleted')) {
                        $app->partner_db->$block_model->edit($block, {mincpm => 50});
                    } else {
                        $app->$block_model->do_action($block, 'edit', mincpm => 50);
                    }
                    say ' OK';
                } else {
                    say ' SKIPPED';
                }
            }
            catch {
                my ($e) = @_;
                say ' ERROR: ' . $e->message;
            };
        }
    }
}

main();
