#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use PiConstants qw($SITE_PARTNER_ROLE_ID $VIDEO_PARTNER_ROLE_ID $MOBILE_PARTNER_ROLE_ID);

use Text::CSV;

sub _get_app {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    return $app;
}

sub main {
    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $app = _get_app();
    my $file = $ARGV[0] // die 'Please supply a path to file';
    open(my $fh, '>', $file) or die "create file: $!";

    my $tsv = Text::CSV->new({eol => "\n"});
    $tsv->print($fh, [qw(ФИО E-mail Phone Domain/BundleID)]);

    my $users = $app->users->get_all(fields => [qw(id name lastname midname roles email phone login)]);

    my $total_partners        = 0;
    my $total_video_partners  = 0;
    my $total_site_partners   = 0;
    my $total_mobile_partners = 0;
    foreach (@$users) {
        my $is_partner = FALSE;
        foreach (@{$_->{'roles'}}) {
            # 9 - Site: Partner
            # 20 - Video: Partner
            # 27 - Mobile: Partner
            if (in_array($_->{'id'}, [$SITE_PARTNER_ROLE_ID, $VIDEO_PARTNER_ROLE_ID, $MOBILE_PARTNER_ROLE_ID])) {
                $is_partner = TRUE;
                last;
            }
        }
        next unless $is_partner;

        my $fio    = join(' ', @$_{qw(lastname name midname)});
        my $email  = $_->{'email'};
        my $phone  = $_->{'phone'};
        my $domain = $app->partner_db->all_pages->get_all(
            fields => [qw(domain product_type is_internal)],
            filter => {owner_id => $_->{'id'}}
        );
        my %uniq_domains;
        my ($is_site, $is_video, $is_mobile) = (0, 0, 0);

        foreach (@$domain) {
            next if $_->{'is_internal'};

            $uniq_domains{$_->{'domain'}}++;

            if ($_->{'product_type'} eq 'mobile') {
                $is_mobile = 1;
            } elsif ($_->{'product_type'} eq 'video') {
                $is_video = 1;
            } else {
                $is_site = 1;
            }
        }
        my @domains = keys(%uniq_domains);

        next unless @domains;
        $total_partners        += 1;
        $total_video_partners  += 1 if $is_video;
        $total_site_partners   += 1 if $is_site;
        $total_mobile_partners += 1 if $is_mobile;

        $phone = join(' ', (map {s/\s+//g} split(/[,\n]/, $phone))) if $phone;
        my $domains = join(' ', @domains);
        my @emails;
        @emails = map {s/\s+//g} split(/[,\n]/, $email) if $email;

        foreach my $email (@emails) {
            $tsv->print($fh, [$fio, $email, $phone, $domains]);
        }
    }

    close($fh);

    say "Total partners: $total_partners";
    say "Total video partners: $total_video_partners";
    say "Total mobile partners: $total_mobile_partners";
    say "Total site partners: $total_site_partners";
}

main();
