#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use Utils::PublicID qw(validate_public_ids);

use Getopt::Long;

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

my $from_block = 'R-V-238458-3';

my @to_blocks = qw(
  R-V-264507-1
  R-V-264507-2
  R-V-264507-3
  R-V-264507-4
  R-V-264507-5
  R-V-264507-6
  R-V-264507-7
  );

sub get_args {
    my $dry_run = 0;

    GetOptions('dry-run' => \$dry_run) or die("Error in command line arguments\n");

    return {'dry-run' => $dry_run};
}

sub main {
    my $args = get_args();
    my $app  = Application->new();
    $app->pre_run();
    $app->set_cur_user({id => 0});

    my ($found, $not_found) = validate_public_ids($app, [$from_block, @to_blocks]);

    die("Can't find public_ids: " . join(' ', @$not_found))
      if @$not_found;

    my $from_accessor = $found->{$from_block};
    my $from_obj =
      ($app->$from_accessor->get_all(fields => [qw(articles brands)], filter => {public_id => $from_block}))->[0];

    foreach (@to_blocks) {
        my $to_accessor = $found->{$_};
        my $to_obj      = (
            $app->$to_accessor->get_all(
                fields => [qw(id page_id multistate articles brands)],
                filter => {public_id => $_}
            )
        )->[0];
        print to_json({model => $to_accessor, %$to_obj}, canonical => 1);

        try {
            $app->$to_accessor->do_action(
                $to_obj, 'edit',
                articles => $from_obj->{'articles'},
                brands   => $from_obj->{'brands'}
            ) unless $args->{'dry-run'};
            say ' OK';
        }
        catch {
            my ($e) = @_;
            say ' ERROR: ' . $e->message;
        };
    }
}

main();
