#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use PiConstants qw(
  $SITE_PARTNER_ROLE_ID
  $VIDEO_PARTNER_ROLE_ID
  $MOBILE_PARTNER_ROLE_ID
  );

use File::Slurp qw(write_file);

sub _get_app {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    return $app;
}

sub main {
    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $app = _get_app();
    my $users = $app->users->get_all(fields => [qw(roles email newsletter)], filter => {newsletter => 1});

    my @all_emails;
    foreach (@$users) {
        my $is_partner = FALSE;
        foreach (@{$_->{'roles'}}) {
            # 9 - Site: Partner
            # 20 - Video: Partner
            # 27 - Mobile: Partner
            if (in_array($_->{'id'}, [$SITE_PARTNER_ROLE_ID, $VIDEO_PARTNER_ROLE_ID, $MOBILE_PARTNER_ROLE_ID])) {
                $is_partner = TRUE;
                last;
            }
        }
        next unless $is_partner;

        my @emails = grep {/@/} split(/[\s,]/, $_->{'email'});
        push @all_emails, @emails;
    }

    my %uniq_hash = map {$_ => 1} @all_emails;

    write_file('PI-11721_partners_emails.txt', join("\n", sort keys(%uniq_hash)));
}

main();
