#!/usr/bin/perl

use lib::abs qw(../../lib);

use qbit;
use Data::Rmap qw(rmap_all);

use Application;

main();

sub main {
    $ENV{'LAZY_LOAD'} = TRUE if in_array('check', \@ARGV);

    my $app = Application->new();

    $app->pre_run();

    $app->set_cur_user({id => 198506264});    #198506264
    {
        no strict 'refs';
        no warnings 'redefine';

        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    my %options = map {$_ => TRUE} @ARGV;

    if (in_array('check', \@ARGV)) {
        check($app);
    } else {
        my $fields = get_fields($app);

        writefile(in_array('dump_master', \@ARGV) ? 'dump_fields_master' : 'dump_fields_refactoring',
            to_json($fields, pretty => TRUE));
    }

    $app->post_run();
}

sub get_fields {
    my ($app) = @_;

    my %all_stat_fields = ();

    my @levels = grep {blessed($app->{$_}) && $app->$_->isa('Application::Model::Statistics::Product')} keys(%$app);

    my @product_ids = ();
    foreach my $level (@levels) {
        push(@product_ids, $app->$level->product->accessor) if $app->$level->can('product');

        my $fields = $app->$level->get_fields(with_shared => TRUE, raw => TRUE);

        foreach my $field (@$fields) {
            $all_stat_fields{$field->{'id'}} = TRUE;
        }
    }

    my $query = Query->new();

    no warnings 'once';

    my @fields = ();
    foreach my $field (sort {$a->{'id'} cmp $b->{'id'}} @Application::Model::Statistics::Product::FIELD_TYPES) {
        next unless $all_stat_fields{$field->{'id'}};

        foreach (qw(shared forced)) {
            $field->{$_} += 0 if exists($field->{$_});
        }

        foreach (qw(title hint short_title)) {
            if (exists($field->{$_})) {
                $field->{$_} = $field->{$_}->();
                #сделал одинаково везде с &nbsp;
                $field->{$_} =~ s/&nbsp;/ /g;
            }
        }

        if (exists($field->{'depends_on'})) {
            my @dep_fields = sort @{$field->{'depends_on'}};

            my $val = 0;
            my $data = {map {$val += 100; ($_ => $val)} @dep_fields};

            $field->{'get'} = $field->{'get'}->($data);

            $field->{'depends_on'} = \@dep_fields;
        }

        if (exists($field->{'clickhouse_expression'})) {
            if (ref($field->{'clickhouse_expression'}) eq 'CODE') {
                $field->{'clickhouse_expression'} = $field->{'clickhouse_expression'}->($field, \@product_ids, $query);
            }

            rmap_all {$_ = ref($_) eq 'REF' || ref($_) eq 'SCALAR' ? $$_ : $_} $field->{'clickhouse_expression'};
        }

        push(@fields, $field);
    }

    return \@fields;
}

sub check {
    my ($app) = @_;

    use Test::More;
    use Test::Deep qw(cmp_deeply);

    my $m = from_json(readfile('dump_fields_master'));
    my $r = from_json(readfile('dump_fields_refactoring'));

    ok(@$m == @$r, 'count');

    for (my $i = 0; $i < @$m; $i++) {
        my $m_rec = $m->[$i];
        my $r_rec = $r->[$i];

        cmp_deeply($r_rec, $m_rec, $m_rec->{'id'});
    }

    done_testing();
}

package Query;

use qbit;

use base qw(QBit::Class);

sub no_money_format {FALSE}

TRUE;
