#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

my @new_dsp_blocks = ('300x250', '300x300', '336x280', '100%x250');

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $blocks = $app->context_on_site_rtb->get_all(
        fields => [qw(campaign_id id multistate dsp_blocks is_custom_bk_data)],
        filter => {site_version => 'turbo'},
    );

    for my $block (@$blocks) {
        try {
            if (   $app->context_on_site_rtb->check_multistate_flag($block->{multistate}, 'deleted')
                || $block->{is_custom_bk_data})
            {
                $app->partner_db->transaction(
                    sub {
                        $app->partner_db->media_sizes->delete(
                            $app->partner_db->filter({page_id => $block->{campaign_id}, block_id => $block->{id}}),
                        );
                        $app->partner_db->media_sizes->add_multi(
                            [
                                map {{page_id => $block->{campaign_id}, block_id => $block->{id}, type => $_}}
                                  @new_dsp_blocks
                            ]
                        );
                    }
                );
            } else {
                $app->context_on_site_rtb->do_action($block, 'edit', dsp_blocks => \@new_dsp_blocks);
            }
            say to_json({data => $block, status => 'OK'});
        }
        catch {
            my ($e) = @_;
            say to_json({data => $block, status => 'ERROR: ' . $e->message});
        };
    }

    say '#END';
}

main();
