#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use File::Slurp qw(write_file read_file);

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    my $lists = update_lists($app);

    for my $model_name (keys(%$lists)) {
        for my $page (@{$lists->{$model_name}}) {
            print to_json({model => $model_name, %$page}, canonical => 1);

            try {
                if ($app->$model_name->check_multistate_flag($page->{multistate}, 'protected')) {
                    throw Exception 'PROTECTED';
                } elsif ($app->$model_name->check_action($page, 'edit')) {
                    $app->$model_name->do_action($page, 'edit', fast_context => 1);
                } else {
                    $app->partner_db->$model_name->edit($page, {fast_context => 1});
                }
                say ' OK';
            }
            catch {
                my ($e) = @_;
                say ' ERROR: ' . $e->message;
            };
        }
    }
}

sub update_lists {
    my ($app) = @_;

    my $models = {};

    if ($ARGV[0] && $ARGV[1]) {
        my ($model_name, $list_file_name) = ($ARGV[0], $ARGV[1]);
        my $page_ids = [map {0 + $_} read_file($list_file_name)];
        my $pages = $app->$model_name->get_all(
            fields => [(qw(id fast_context multistate)), $app->$model_name->get_page_id_field_name],
            filter => {$app->$model_name->get_page_id_field_name => $page_ids},
        );
        $models->{$model_name} = $pages;
    } else {
        for my $model_name (qw(mobile_app_settings internal_mobile_app)) {
            my $pages = $app->$model_name->get_all(
                fields => [(qw(id fast_context multistate)), $app->$model_name->get_page_id_field_name],);
            $models->{$model_name} = [grep {$_->{fast_context} == 0} @$pages];
        }
    }

    return $models;
}

main();
