#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $blocks = $app->partner_db->context_on_site_rtb->get_all(
        fields => [qw(campaign_id id is_custom_bk_data)],
        filter => {direct_block => 'extensibleMobile', site_version => 'turbo', is_custom_format_direct => 0},
    );

    for my $b (@$blocks) {
        say to_json($b);
        try {
            if ($b->{is_custom_bk_data} || !$app->context_on_site_rtb->check_action($b, 'edit')) {
                $app->partner_db->context_on_site_rtb->edit($b, {direct_block => 'adaptive0418'});
            } else {
                $app->context_on_site_rtb->do_action($b, 'edit', direct_block => 'adaptive0418');
            }
        }
        catch {
            my ($exception) = @_;
            say 'ERROR: ' . $exception->message;
        };
    }

    say '#END';
}

main();
