#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

  Нужно подключит прод базу, БК и Баланс
  Так же в конфиге нужно выставить stage = production

=cut

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use Pod::Usage;
use Getopt::Long qw();

use qbit;
use Application;

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

my $PAGE_INFO = {
    149322 => {model => 'search_on_site_campaign'},
    142768 => {model => 'context_on_site_campaign'},
    147061 => {model => 'context_on_site_campaign'},
};

my $DOMAIN_ID = 74;
my $DOMAIN    = 'travel.yandex.ru';

my $STASH = {};

my $CONTEXT_MIGRATIONS = [
    {
        table     => 'quality_pages_coef',
        new_table => 'quality_pages_coef',
        filter    => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {page_id => $old_page_id};
        },
        change_row => sub {
            my ($app, $old_page_id, $new_page_id, $row) = @_;

            $row->{'page_id'} = delete($row->{'campaign_id'});
        },
        delete_filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {page_id => $new_page_id};
        },
    },
    {
        table  => 'context_on_site_ya_categories',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {campaign_id => $old_page_id};
        },
    },
    {
        table  => 'context_on_site_adblock',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                page_id    => $old_page_id,
                multistate => $app->context_on_site_adblock->get_multistates_by_filter('not deleted')
            };
        },
        throw_if_exists => 1,
    },
    {
        table  => 'context_on_site_adblock_dsps',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {page_id => $old_page_id};
        },
        throw_if_exists => 1,
    },
    {
        table  => 'context_on_site_direct',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->context_on_site_direct->get_multistates_by_filter('not deleted')
            };
        },
        stash => sub {
            my ($app, $old_page_id, $new_page_id, $row) = @_;

            push(@{$STASH->{'context_on_site_direct'}{'id'}}, $row->{'id'});
          }
    },
    {
        table  => 'context_on_site_direct_tag',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return ['AND',
                [['campaign_id', '=', \$old_page_id], ['id', 'IN', \$STASH->{'context_on_site_direct'}{'id'}]]];
        },
        change_row => sub {
            my ($app, $old_page_id, $new_page_id, $row) = @_;

            $row->{'id_with_campaign_id'} = "$row->{'id'}_$row->{'campaign_id'}";
        },
    },
    {
        table  => 'context_on_site_market',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->context_on_site_market->get_multistates_by_filter('not deleted')
            };
        },
        throw_if_exists => 1,
    },
    {
        table  => 'context_on_site_market_api',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->context_on_site_market_api->get_multistates_by_filter('not deleted')
            };
        },
        throw_if_exists => 1,
    },
    {
        table  => 'context_on_site_mcb',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->context_on_site_mcb->get_multistates_by_filter('not deleted')
            };
        },
        throw_if_exists => 1,
    },
    {
        table  => 'context_on_site_stripe',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->context_on_site_stripe->get_multistates_by_filter('not deleted')
            };
        },
    },
    {
        table  => 'context_on_site_rtb',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->context_on_site_rtb->get_multistates_by_filter('not deleted')
            };
        },
        stash => sub {
            my ($app, $old_page_id, $new_page_id, $row) = @_;

            push(@{$STASH->{'context_on_site_rtb'}{'id'}}, $row->{'id'});
          }
    },
    {
        table  => 'media_sizes',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return ['AND',
                [['page_id', '=', \$old_page_id], ['block_id', 'IN', \$STASH->{'context_on_site_rtb'}{'id'}]]];
        },
    },
    {
        table  => 'context_on_site_dsps',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return [
                'AND', [['campaign_id', '=', \$old_page_id], ['block_id', 'IN', \$STASH->{'context_on_site_rtb'}{'id'}]]
            ];
        },
    },
    {
        table     => 'brands',
        new_table => 'brands',
        filter    => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return ['AND',
                [['page_id', '=', \$old_page_id], ['block_id', 'IN', \$STASH->{'context_on_site_rtb'}{'id'}]]];
        },
        change_row => sub {
            my ($app, $old_page_id, $new_page_id, $row) = @_;

            delete($row->{'id'});
            $row->{'page_id'} = delete($row->{'campaign_id'});
        },
        delete_filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {page_id => $new_page_id};
        },
    },
    {
        table  => 'context_on_site_block_seq',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {campaign_id => $old_page_id};
        },
    },
];

my $SEARCH_MIGRATIONS = [
    {
        table  => 'search_on_site_direct',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->search_on_site_direct->get_multistates_by_filter('not deleted')
            };
        },
    },
    {
        table  => 'search_on_site_market',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->search_on_site_market->get_multistates_by_filter('not deleted')
            };
        },
        throw_if_exists => 1,
    },
    {
        table  => 'search_on_site_market_api',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->search_on_site_market_api->get_multistates_by_filter('not deleted')
            };
        },
        throw_if_exists => 1,
    },
    {
        table  => 'search_on_site_mcb',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->search_on_site_mcb->get_multistates_by_filter('not deleted')
            };
        },
        throw_if_exists => 1,
    },
    {
        table  => 'search_on_site_premium',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {
                campaign_id => $old_page_id,
                multistate  => $app->search_on_site_premium->get_multistates_by_filter('not deleted')
            };
        },
    },
    {
        table  => 'search_on_site_block_seq',
        filter => sub {
            my ($app, $old_page_id, $new_page_id) = @_;

            return {campaign_id => $old_page_id};
        },
    },
];

main();

sub main {
    my $app = Application->new();

    $app->pre_run();

    $app->set_cur_user({id => 0});

    foreach my $page_id (sort keys(%$PAGE_INFO)) {
        say "START Page ID: $page_id";

        $STASH = {};

        my $id = $PAGE_INFO->{$page_id}{'id'};
        unless (defined($id)) {
            $id = copy_pages($app, $page_id);
        }

        delete_from_table($app, $page_id, $id);

        copy_tables($app, $page_id, $id);

        say "END Page ID: $page_id";
    }

    $app->post_run();

    say "#END";
}

sub delete_from_table {
    my ($app, $page_id, $campaign_id) = @_;

    my $migrations =
      $PAGE_INFO->{$page_id}{'model'} eq 'context_on_site_campaign' ? $CONTEXT_MIGRATIONS : $SEARCH_MIGRATIONS;

    foreach my $migr (reverse @$migrations) {
        next if $migr->{'throw_if_exists'};

        my $table = $migr->{'table'};

        say "START DELETE FROM TABLE: $table";

        my $new_table = $migr->{'new_table'} // 'internal_' . $table;

        my $action_log = $new_table . '_action_log';
        if ($app->partner_db->can($action_log)) {
            my $filter_action_log = $app->partner_db->filter({elem_campaign_id => $campaign_id});

            $app->partner_db->$action_log->delete($filter_action_log);
        }

        my $filter = $app->partner_db->filter(
              $migr->{'delete_filter'}
            ? $migr->{'delete_filter'}->($app, $page_id, $campaign_id)
            : {campaign_id => $campaign_id}
        );

        $app->partner_db->$new_table->delete($filter);

        say "END DELETE FROM TABLE: $table";
    }
}

sub copy_pages {
    my ($app, $page_id) = @_;

    my $model     = $PAGE_INFO->{$page_id}{'model'};
    my $new_model = 'internal_' . $model;

    my $add_fields = $app->$new_model->get_add_fields();

    my $settings = $app->$model->get_all(fields => ['*'], filter => {page_id => $page_id})->[0];

    $settings->{'domain_id'} = $DOMAIN_ID;
    $settings->{'domain'}    = $DOMAIN;

    my %data_for_create = hash_transform($settings, [keys(%$add_fields)]);

    say 'DATA FOR CREATE: ' . to_json(\%data_for_create);

    my $id = $app->$new_model->add(%data_for_create);

    say "CREATED ID: $id";

    say "REPLACE PAGES: $page_id => $id";

    $app->$new_model->do_action($id, 'register_in_balance');

    my $fields = $app->$new_model->get_model_fields();
    my @ignore_fields = grep {!$fields->{$_}} keys(%$settings);

    say 'IGNORE FIELDS: ' . to_json(\@ignore_fields) if @ignore_fields;

    my $editable_fields = $app->$new_model->get($id, fields => [qw(editable_fields)])->{'editable_fields'};

    my %data_for_update =
      map {exists($settings->{$_}) ? ($_ => $settings->{$_}) : ()} keys(%$editable_fields);

    #fix mirrors
    $data_for_update{'mirrors'} = [map {$_->{'domain'}} @{$data_for_update{'mirrors'}}];

    say 'UPDATE: ' . to_json(\%data_for_update);

    $app->$new_model->do_action($id, 'edit', %data_for_update);

    return $id;
}

sub copy_tables {
    my ($app, $page_id, $campaign_id) = @_;

    my $migrations =
      $PAGE_INFO->{$page_id}{'model'} eq 'context_on_site_campaign' ? $CONTEXT_MIGRATIONS : $SEARCH_MIGRATIONS;

    foreach my $migr (@$migrations) {
        my $table = $migr->{'table'};

        say "START TABLE: $table";

        my $new_table = $migr->{'new_table'} // 'internal_' . $table;

        my $data = $app->partner_db->$table->get_all(
            fields => [map {$_->name} @{$app->partner_db->$table->fields}],
            filter => $migr->{'filter'}->($app, $page_id, $campaign_id)
        );

        if ($migr->{'throw_if_exists'} && @$data) {
            throw 'Can not move this product';
        } elsif ($migr->{'throw_if_exists'} && !@$data) {
            say "END TABLE: $table";

            next;
        }

        my $fields = [map {$_->name} @{$app->partner_db->$new_table->fields}];

        foreach my $row (@$data) {
            $row->{'campaign_id'} = $campaign_id;

            if ($migr->{'change_row'}) {
                $migr->{'change_row'}->($app, $page_id, $campaign_id, $row);
            }

            if (exists($row->{'bk_data'}) && $row->{'bk_data'}) {
                my $public_id = $app->$table->public_id({campaign_id => $page_id, id => $row->{'id'}});
                my $new_public_id = $app->$new_table->public_id({campaign_id => $campaign_id, id => $row->{'id'}});

                $row->{'bk_data'} =~ s/$public_id/$new_public_id/g;
            }

            $row = {hash_transform($row, $fields)};

            if ($migr->{'stash'}) {
                $migr->{'stash'}->($app, $page_id, $campaign_id, $row);
            }
        }

        if (@$data) {
            say 'INSERT DATA: ', to_json($data);

            $app->partner_db->$new_table->add_multi($data);
        }

        say "END TABLE: $table";
    }
}
