#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Скрипт выставляет флаг need_update на всех работающих/тестируемых ппейджах,
которых коснулись изменения выставления DSP из тикета
https://st.yandex-team.ru/PI-12379

Для работы скрипта нужно подключить продакшн базу.
Никаке другие продакшн системы подключать не нужно.

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

# global vars

my @ignore_logins = ('adv-vertis', 'kp-team', 'yamarketadv');
my @models = ('context_on_site_rtb');

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my @new_dsps = @ARGV;
    for my $dsp_id (@new_dsps) {
        say "dsp $dsp_id start_on_all_platforms";
        my $dsp = $app->dsp->get($dsp_id, fields => [qw(multistate)]);
        $app->dsp->do_action($dsp_id, 'start_on_all_platforms')
          unless $app->dsp->check_multistate_flag($dsp->{multistate}, 'working_on_all_platforms');
    }

    for my $block_model (@models) {

        my $block_table        = $app->$block_model->db_table_name();
        my $page_model         = $app->$block_model->get_campaign_model_name();
        my $page_id_field_name = $app->$block_model->get_page_id_field_name();
        my $dsp_model;
        if ($block_model =~ m/_rtb$/) {
            $dsp_model = $block_model;
            $dsp_model =~ s/_rtb$/_dsps/;
        } else {
            $dsp_model = $block_model . '_dsps';
        }
        my $dsp_table = $app->$dsp_model->db_table_name();

        my $ignore_logins_joined = join(',', (map {"'$_'"} @ignore_logins));

        for my $dsp_id (@new_dsps) {
            say "replace into $dsp_table dsp $dsp_id";
            $app->partner_db->_do("
                replace into $dsp_table (`$page_id_field_name`, `block_id`, `dsp_id`, `is_deleted`)
                select $page_id_field_name, id as block_id, $dsp_id as dsp_id, 0 as is_deleted from $block_table
                where
                    id <> 100500
                    and $page_id_field_name not in (select page_id from all_pages where login in ($ignore_logins_joined))
                    and private_auction <> 1
                ;
            ");
        }

        my %multistate_bits = map {$_->[0] => 1} @{$app->$page_model->get_multistates_bits();};

        my $filter = '(working or testing) and not need_update';

        if ($multistate_bits{protected}) {
            $filter .= ' and not protected';
        }

        if ($multistate_bits{read_only}) {
            $filter .= ' and not read_only';
        }

        my $data = $app->$page_model->get_all(
            fields => [qw(id page_id multistate cur_user_is_read_assistant)],
            filter => {multistate => $filter,}
        );

        my %page_ids = map {$_->{$page_id_field_name} => 1} @{
            $app->partner_db->$dsp_table->get_all(
                fields   => [$page_id_field_name],
                filter   => {dsp_id => \@new_dsps},
                distinct => TRUE
            )
          };

        my $data_to_update = [];

        foreach my $el (@$data) {
            # формат данных:
            #{
            #    domain_id => 3,
            #    id => 1,
            #    owner_id => 356502796,
            #    page_id => 41443,
            #}

            if ($page_ids{$el->{page_id}}) {
                push @$data_to_update, $el;
            }
        }

        my $all_count = scalar(@$data_to_update);
        say 'Number of Page IDs to set flag need_update: ' . $all_count . "\n";

        my $i = 0;
        foreach my $el (sort {$a->{page_id} <=> $b->{page_id}} @$data_to_update) {
            $i++;
            try {
                $app->$page_model->do_action($el, 'set_need_update');
                say "making action 'set_need_update' on Page ID $el->{page_id} ($i/$all_count)\n";
            }
            catch {
                my ($exception) = @_;
                say 'ERROR: ' . $exception->message;
            }
        }
    }

    $app->post_run();
    say "#END";
}

main();
__END__
