#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $multistates = $app->dsp->get_multistate_names();

    $app->partner_db->dsp->edit({id => 2},
        {multistate => ['&', ['multistate', \(~(0 + $multistates->{'working_on_all_platforms'}))]],});

    # https://st.yandex-team.ru/PI-12812#1532094446000
    open(my $fh, '<', 'rtb-awaps.tsv') or die "open: $!";

    my $tsv =
      Text::CSV_XS->new({binary => 1, sep_char => "\t", eol => "\n", escape_char => undef, quote_char => undef});
    $tsv->column_names($tsv->getline($fh));

    my $blocks = $tsv->getline_hr_all($fh);

    close($fh) or die "close: $!";

    for my $block_model (sort @{$app->product_manager->get_block_model_names()}) {
        my $dsp_model;
        if ($block_model =~ m/_rtb$/) {
            $dsp_model = $block_model;
            $dsp_model =~ s/_rtb$/_dsps/;
        } else {
            $dsp_model = $block_model . '_dsps';
        }

        unless ($app->can($dsp_model)) {
            say "$block_model - no dsp model";
            next;
        }

        my $dsp_table = $app->$dsp_model->db_table_name();

        my $filtered_blocks = select_blocks($app, $blocks, $block_model, $dsp_table);

        unless (@$filtered_blocks) {
            say "$block_model - $dsp_model - no affected blocks";
            next;
        }

        my $delete_count = delete_dsps($app, $filtered_blocks, $block_model, $dsp_table);
        my $update_count = update_pages($app, $filtered_blocks, $block_model);

        say "$block_model - $dsp_model - deleted $delete_count, updated $update_count";
    }

    say '#END';
}

sub select_blocks {
    my ($app, $blocks, $block_model, $dsp_table) = @_;

    my $block_table        = $app->$block_model->db_table_name();
    my $page_id_field_name = $app->$block_model->get_page_id_field_name();

    my $list = join(',', map {"($_->{pageid}, $_->{impid}, 2)"} @$blocks);
    my $select_sql =
"SELECT $page_id_field_name as page_id, block_id FROM $dsp_table WHERE ($page_id_field_name, block_id, dsp_id) in ($list)";

    return $app->partner_db->_get_all($select_sql);
}

sub delete_dsps {
    my ($app, $blocks, $block_model, $dsp_table) = @_;

    my $page_id_field_name = $app->$block_model->get_page_id_field_name();

    my $list = join(',', map {"($_->{page_id}, $_->{block_id}, 2)"} @$blocks);
    my $delete_sql = "DELETE FROM $dsp_table WHERE ($page_id_field_name, block_id, dsp_id) in ($list)";

    return $app->partner_db->_do($delete_sql);
}

sub update_pages {
    my ($app, $blocks, $block_model) = @_;

    my $page_model         = $app->$block_model->get_campaign_model_name();
    my $page_table         = $app->$page_model->db_table_name();
    my $page_id_field_name = $app->$page_model->get_page_id_field_name();
    my $page_need_update   = 0 + $app->$page_model->get_multistate_names()->{need_update};

    my $list = join(',', map {$_->{page_id}} @$blocks);
    my $update_sql =
      "UPDATE $page_table SET multistate = multistate | $page_need_update WHERE $page_id_field_name in ($list)";

    return $app->partner_db->_do($update_sql);
}

main();
