#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Скрипт
1. перемещает файлы из lib/qbit в lib/QBit и t/lib/qbit в t/lib/QBit
2. меняет вхождения qbit:: на QBit::

=cut

use strict;
use warnings;

use utf8;

use FindBin qw($Bin);
use File::Basename;
use File::Path;
use File::Slurp;

chdir "$Bin/../..";

my @files;
push @files, map {chomp; $_} `find ./lib/qbit/ -type f`;
push @files, map {chomp; $_} `find ./t/lib/qbit/ -type f`;

foreach my $path (@files) {
    (my $new_path = $path) =~ s|qbit/|QBit/|;
    my $dirname = File::Basename::dirname($new_path);
    `mkdir -p $dirname`;
    `git mv $path $new_path`;
}

File::Path::rmtree('./lib/qbit');
`git add ./lib/qbit`;

File::Path::rmtree('./t/lib/qbit');
`git add ./t/lib/qbit`;

@files = map {chomp; $_} `grep -lr 'qbit'  ./lib  ./t_lib  ./t  ./utils`;

foreach my $path (@files) {
    my $content = File::Slurp::read_file($path);
    $content =~ s/qbit::/QBit::/g;
    File::Slurp::write_file($path, \$content);
    `git add $path`;
}
