#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

my @page_ids = (
    260228, 260227, 260226, 260225, 260214, 260215, 260223, 259601, 260087, 260077, 259773, 260002, 259865, 259701,
    259864, 259856, 260105, 260103, 261444, 260099, 260229, 260232, 260165, 260166, 263517, 260167, 260224, 259869,
    260230, 260244, 260243, 261452, 191823, 199004, 261606, 263018, 263192, 263881, 263882, 263884, 266894, 266915,
    267051, 267071, 267075, 267184, 267308, 267313, 267914, 267924, 268443, 268504, 268575, 269587, 269605, 269638,
    269643, 270333, 270765, 270900, 270922, 272256, 272257, 272769, 273731, 274925, 275209, 275930, 276119, 276178,
    277554, 281929, 284761, 286453, 287074,
);

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    for my $block_model (qw(video_an_site_instream)) {
        my $blocks = $app->$block_model->get_all(
            fields => [qw(page_id id multistate max_duration count_positions is_custom_bk_data)],
            filter => {page_id => \@page_ids},
        );

        for my $block (@$blocks) {
            print to_json({model => $block_model, %$block}, canonical => 1);

            try {
                if (   $app->$block_model->check_multistate_flag($block->{multistate}, 'deleted')
                    || $block->{is_custom_bk_data})
                {
                    $app->partner_db->$block_model->edit($block, {max_duration => 90, count_positions => 3});
                } else {
                    $app->$block_model->do_action($block, 'edit', max_duration => 90, count_positions => 3);
                }
                say ' OK';
            }
            catch {
                my ($e) = @_;
                say ' ERROR: ' . $e->message;
            };
        }
    }
}

main();
