#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

  Нужно подключить прод базу, БК и Баланс
  Так же в конфиге нужно выставить stage = production

=head1 USAGE

    script.pl  --die_on_debug

=head1 OPTIONS

  die_on_debug - рандомно вызывать die в процессе копирования для тестирования механихма восстановления после сбоя

=cut

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use Pod::Usage;
use Getopt::Long qw();
use File::Slurp qw( read_file  write_file );
use Utils::Logger qw( INFO INFOF );

use qbit;
use Application;

my $STASH          = [];
my $DIE_ON_DEBUG   = 0;
my $PAGES_TO_CLONE = [
    {
        page_accessor    => 'video_an_site',
        blocks_accessors => ['video_an_site_inpage', 'video_an_site_instream', 'video_an_site_fullscreen',],
        pages_to_clone   => {
            266894 => {
                login           => 'kp-team',
                domain_template => 'kinopoisk.ru',
                number_from     => 1,
                number_to       => 30,
            },

            260214 => {
                login           => 'kp-team',
                domain_template => 'kinopoisk.ru',
                number_from     => 1,
                number_to       => 20,
            },
            267184 => {
                login           => 'kp-team',
                domain_template => 'kinopoisk.ru',
                number_from     => 1,
                number_to       => 20,
            },
        }
    }
];

my $res_file_path = './PI-13108_clone_pages_res_data.json';

main();

sub main {

    my $help;
    Getopt::Long::GetOptions(
        'die_on_debug' => \$DIE_ON_DEBUG,
        'help|?|h'     => \$help,
    ) or pod2usage(1);

    pod2usage(-verbose => 2, -noperldoc => 1) if $help;

    my $app = _get_app();
    $STASH = get_stash();

    try {
        _clone_all_pages($app);
    }
    catch {
        my ($e) = @_;
        save_stash($STASH);
        say $@;
        throw $e;
    };
    save_stash($STASH);
    $app->post_run();
    INFO "\#END";
}

sub get_stash {

    my $content = eval {read_file($res_file_path, binmode => ':utf8')};
    my $data = eval {from_json($content)} // [];
    return $data;

}

sub save_stash {

    my $content = eval {to_json($STASH)};
    write_file($res_file_path, {binmode => ':utf8'}, \$content);

}

sub _get_app {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    no strict 'refs';
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};

    return $app;
}

sub _clone_all_pages {
    my $app = shift @_;
    foreach my $accessors (@$PAGES_TO_CLONE) {

        my $stash = {};
        foreach (@$STASH) {
            $stash = $_ if exists $_->{page_accessor} && $_->{page_accessor} eq $accessors->{page_accessor};
        }
        push @$STASH, $stash if !%$stash;

        if (exists $stash->{completed} && $stash->{completed}) {
            INFOF "\nSkip model %s", $accessors->{page_accessor};
            next;
        }
        INFOF "\nStart Model: %s", $accessors->{page_accessor};

        $stash->{page_accessor} = $accessors->{page_accessor};
        $stash->{cloned_pages} //= {};

        foreach my $page_id (sort keys(%{$accessors->{pages_to_clone}})) {
            my $stash_page = $stash->{cloned_pages}->{$page_id} //= {};

            if (exists $stash_page->{completed} && $stash_page->{completed}) {
                INFO "\nSkip Page ID: $page_id";
                next;
            }
            INFO exists $stash_page->{current_iteration} ? "Continue" : "Start", " clone Page ID: $page_id";

            _process_page_id($app, $accessors, $page_id, $stash_page);

            INFO "\nEND Page ID: $page_id";
            $stash_page->{completed} = TRUE;
        }
        $stash->{completed} = TRUE;
    }
}

sub _clone_blocks {

    my ($app, $block, $stash_block, $block_add_fields) = @_;

    my $block_edit_fields = $block->{editable_fields};

    my %block_to_add  = %$block;
    my %block_to_edit = %$block;

    delete $block_to_add{$_}  foreach (grep {!$block_add_fields->{$_}} keys %{$block});
    delete $block_to_edit{$_} foreach (grep {!$block_edit_fields->{$_}} keys %{$block});

    my $cloned_block_id = $stash_block->{cloned_block_id} //= $app->$_->add(%block_to_add);
    INFOF "Block ID: %s cloned to block: %s", $block->{id}, $cloned_block_id;

    $stash_block->{cloned_block_edited} //= $app->$_->do_action($cloned_block_id, 'edit', %block_to_edit);
    $stash_block->{completed} = TRUE;
    die if $DIE_ON_DEBUG && rand(10) > 8;
}

sub _clone_page {
    my ($app, $accessors, $page_id, $stash_page, $page_to_add, $page_to_edit) = @_;

    my $accessor = $accessors->{page_accessor};
    $page_to_add->{domain} = sprintf $accessors->{pages_to_clone}->{$page_id}->{domain_template},
      $stash_page->{current_iteration};
    $page_to_edit->{caption} = $page_to_add->{caption} . "_" . $stash_page->{current_iteration};
    delete $page_to_edit->{pixels} if not defined $page_to_edit->{pixels};

    foreach (qw(excluded_domains excluded_phones mirrors assistants filters categories blockings)) {
        delete $page_to_edit->{$_} if ref($page_to_edit->{$_}) eq 'ARRAY' && !scalar @{$page_to_edit->{$_}};
    }
    my $cloned_id = $stash_page->{cloned_page_id} //= $app->$accessor->add(%$page_to_add);

    INFOF "\nPage ID:%s cloned to Page ID:%s", $page_id, $cloned_id;
    my $cloned_page = $app->$accessor->get_all(fields => ['*'], filter => {"id" => $cloned_id})->[0];
    #    $stash_page->{cloned_page_edited} //= $app->$accessor->on_action_edit($cloned_page, %$page_to_edit);
    $stash_page->{cloned_page_edited} //= $app->$accessor->do_action($cloned_page, 'edit', %$page_to_edit);

    foreach (@{$accessors->{blocks_accessors}}) {
        my $stash_blocks_accessor = $stash_page->{cloned_blocks}->{$_} //= {};

        if (defined $stash_blocks_accessor->{completed} && $stash_blocks_accessor->{completed}) {
            INFO "\nSkip block accessor $_";
            next;
        }

        my $block_add_fields = $app->$_->get_add_fields;
        my $blocks_to_clone = $app->$_->get_all(fields => ['*'], filter => {"page_id" => $page_id});

        foreach my $block (@$blocks_to_clone) {
            my $stash_block = $stash_blocks_accessor->{$block->{id}} //= {};

            if (exists $stash_block->{completed} && $stash_block->{completed}) {
                INFOF "Skip block ID:%s", $block->{id};
                next;
            }

            $block->{page_id} = $cloned_id;

            _clone_blocks($app, $block, $stash_blocks_accessor->{$block->{id}} //= {}, $block_add_fields);
        }
        $stash_blocks_accessor->{completed} = TRUE;
    }

}

sub _process_page_id {
    my ($app, $accessors, $page_id, $stash) = @_;

    my $accessor = $accessors->{page_accessor};

    my $page = $app->$accessor->get_all(fields => ['*'], filter => {"id" => $page_id})->[0];
    my $add_fields = $app->$accessor->get_add_fields;

    my $edit_fields  = $page->{editable_fields};
    my %page_to_add  = %$page;
    my $page_to_edit = $page;

    delete $page_to_add{$_}    foreach (grep {!$add_fields->{$_}} keys %{$page});
    delete $page_to_edit->{$_} foreach (grep {!$edit_fields->{$_}} keys %{$page});

    $stash->{current_iteration} //= 0;
    my $accessor_page_id = $accessors->{pages_to_clone}->{$page_id};
    for my $index ($accessor_page_id->{number_from} .. $accessor_page_id->{number_to}) {

        if ($index < $stash->{current_iteration}) {
            INFO "\nSkip iteration $index";
            next;
        }
        INFOF "\nStart iteration:%s of %s", $index - $accessor_page_id->{number_from} + 1,
          $accessor_page_id->{number_to} - $accessor_page_id->{number_from} + 1;

        $stash->{current_iteration} = $index;
        $stash->{cloned_blocks} //= {};

        _clone_page($app, $accessors, $page_id, $stash, \%page_to_add, $page_to_edit);

        delete $stash->{$_} foreach (qw(cloned_page_id cloned_page_edited cloned_blocks));

    }
}
