#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;
use Text::CSV_XS;
use DDP;

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $tsv = Text::CSV_XS->new({binary => 1, sep_char => ",", eol => "\n", quote_char => undef, escape_char => undef});

    my $path = 'clients-2.csv';
    open(my $fh, '<', $path) or die "open: $!";
    $tsv->column_names(@{$tsv->getline($fh)});

    my %links;
    my %adfox_info;
    my %pi_info;
    while (my $line = $tsv->getline_hr($fh)) {
        # Делаем хеш хешей со связями. Добавляем префикс, чтобы не пересеклись и чтобы потом восставновить.
        # {
        #   ...
        #   __ADFOX__adfox_login => {
        #       __PI__pi_login => 1,
        #   },
        #   ...
        #   __PI__pi_login => {
        #       __ADFOX__adfox_login => 1,
        #   },
        #   ...
        # }
        $links{"__ADFOX__$line->{account}"}{"__PI__$line->{pi_login}"} = 1;
        $links{"__PI__$line->{pi_login}"}{"__ADFOX__$line->{account}"} = 1;

        # Сохраняем логин из ПИ, чтобы потом сходить за активным договором
        $pi_info{$line->{pi_login}} = 1;
        # Сохраняем инфу про аккаунт из адфокса
        $adfox_info{$line->{account}} = $line;
    }
    $tsv->eof  or $tsv->error_diag();
    close($fh) or die "close: $!";

    # Достаем активные договоры для нужных логинов
    %pi_info =
      map {$_->{login} => $_}
      @{$app->users->get_all(fields => [qw(id login active_contract)], filter => {login => [keys %pi_info]})};

    my $i = 0;
    # Пока остались логины
    while (my $login = (keys(%links))[0]) {
        # Достаем связную компоненту. Из исходного хеша записи удаляются.
        my %cc = connected_component($login, \%links);

        my %names;
        my %different_names;
        for my $login (keys %cc) {
            if ($login =~ s/^__ADFOX__(.*)$/$1/) {
                # Достаем имя организации для логина из адфокса (пришел из csv-шки)
                my $name = $adfox_info{$login}{name};
                # Удаляем кавычки руками, если они есть. Приходится, тк кривые данные с незамаскированными кавычками
                $name =~ s/^"|"$//g;
                # Сохраняем исходное имя
                $names{adfox}{$login} = $name;
                # Приводим всяческие кавычки к одному типу
                $name =~ s/[«»“”]/"/g;
                # Сохраняем нормализованный вариант
                $different_names{$name} = 1;
            } elsif ($login =~ s/^__PI__(.*)$/$1/) {
                # Достаем название из активного договора. Первый вариант - юрик, второй - физик, если undef - активного договора нет
                my $name = $pi_info{$login}{active_contract}{Person}{longname}
                  || $pi_info{$login}{active_contract}{Person}{name};
                $names{pi}{$login} = $name // 'Нет активного договора в ПИ';
                # Логины без активного договора нас не интересуют
                if (defined $name) {
                    # Нормализуем кавычки
                    $name =~ s/[«»“”]/"/g;
                    $different_names{$name} = 1;
                }
            } else {
                die '(((';
            }
        }

        # Если имена организаций для всех логинов совпадают, то конфликта нет, все ок.
        # Иначе печатаем имена для всего пучка логинов
        if (keys(%different_names) > 1) {
            $i += 1;
            say "--- $i ---";
            p %names;
        }
    }

    say '#END';
}

sub connected_component {
    my ($key, $all_links) = @_;
    my $links_for_current_key = delete $all_links->{$key};

    return ("$key" => 1) if keys(%$links_for_current_key) == 0;

    for my $linked_with_current_key (keys %$links_for_current_key) {
        delete $all_links->{$linked_with_current_key}{$key};
    }

    return ((map {connected_component($_, $all_links)} keys(%$links_for_current_key)), "$key" => 1,);
}

main();
