#!/usr/bin/perl

# Нужно настроить базу на прод

=encoding UTF-8

=head1 DESCRIPTION

Скрипт получаеи и прописывает page_id для mobile_app_settings созданных до 2018-09-21

=head1 PARAMS

  commit - внести изменения
  check  - показать изменяемые записи

=head1 USAGE

  bin/oneshots/PI-13156_fix_old_mobile_app_settings.pl  --check
  bin/oneshots/PI-13156_fix_old_mobile_app_settings.pl  --commit

=cut

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use Pod::Usage;
use Getopt::Long qw();

use qbit;
use Application;

my ($CHECK, $COMMIT, $SHOW);
my @fields = qw(id application_id owner_id create_date);

sub main {
    my $app   = _get_app();
    my $model = $app->mobile_app_settings;
    my $list  = get_list($model);
    if ($CHECK) {
        printf "%8s %8s %16s %s\n", @fields;
        for my $row (@$list) {
            printf "%8d %8d %16d %s\n", @{$row}{@fields};
        }
        printf "Total: %d\n", scalar(@$list);
    }
    if ($COMMIT) {
        my $count = 0;
        for my $row (@$list) {
            my $id = get_next_page_id($app, 'pi-manual');
            $count += do_change($model, $row, $id);
        }
        printf "Total: %d\n", $count;
    }
}

sub do_change {
    my ($model, $row, $id) = @_;

    my $res = $model->partner_db_table->edit($row, {context_page_id => $id});
    return $res;
}

sub get_list {
    my ($model) = @_;

    my $filter = $model->partner_db->filter([context_page_id => 'IS' => \undef]);
    my $query = $model->partner_db->query->select(
        table  => $model->partner_db_table(),
        fields => $model->_get_fields_obj(\@fields)->get_db_fields(),
        filter => $filter,
    );
    $SHOW && warn(($query->get_sql_with_data)[0] . "\n");
    return ($CHECK || $COMMIT) && $query->get_all;
}

sub get_next_page_id {
    my ($app, $service) = @_;
    my $result = $app->api_utils_partner2->call('/intapi/get_next_page_id', service => $service, ':post' => TRUE);
    return $result->{'page_id'};
}

sub _get_app {
    _get_args();

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0, login => 'system-cron'});
    my $curuser = $app->get_option('cur_user');

    no strict 'refs';
    no warnings 'redefine';
    *{'QBit::Application::check_rights'} = sub {TRUE};

    return $app;
}

sub _get_args {
    my $help;
    Getopt::Long::GetOptions(
        'check!'   => \$CHECK,
        'commit!'  => \$COMMIT,
        'show!'    => \$SHOW,
        'help|?|h' => \$help,
    ) or pod2usage(1);

    pod2usage(-verbose => 2, -noperldoc => 1) if $help;
}

main();
