#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт создает новые пейджи основываясь на пейдже с id 327561.
    Для новых пейджей создает istrem блоки.

    NOTE! Нужно подключить прод базу. Если скрипт запускается не на проде,
    помимо подключения прод. базы следует:
        настроить на прод api_utils_partner2
        подключить прод БК и Баланс
        в конфиге stage поменять на прод

=head1 USAGE

       LAZY_LOAD=1 script.pl --file_path=path/to/file/with/logins

=cut

use feature 'say';
use lib::abs qw(../../lib);
use File::Slurp qw(read_file write_file);
use Pod::Usage;
use Getopt::Long qw();
use Term::ANSIColor qw(colored);
use qbit;
use Utils::CSV;
use Application;
use Utils::Logger qw(WARN WARNF);

my $TEMPALTE_PAGE_ID    = 327561;
my @PAGE_EDIT_FIELDS    = qw(filters unmoderated_rtb_auction excluded_domains excluded_phones);
my @DSPS_SHORT_CAPTIONS = ('AWAPS Video', 'AWAPSVideoAuction', 'Директ');
use constant MIDROLL => 2;

my $BLOCK_SETTING_TEMPLATE = {
    adfox_block     => 0,
    blind           => 0,
    category_id     => 1023,
    category_path   => 'VH: Турбо',
    caption         => "Instream Турбо мидролл 15сек",
    count_positions => 2,

    geo          => undef,
    max_duration => 60,
    strategy     => 0,
    mincpm       => 50,

    video_active              => undef,
    video_blocked             => undef,
    video_cpm                 => undef,
    video_performance_active  => undef,
    video_performance_blocked => undef,
    video_performance_cpm     => undef,

    type                   => MIDROLL,
    video_motion           => 1,
    allow_multiple_dsp_ads => 1,

    start_time        => 15,
    repeat            => 1,
    broadcast_replace => 0,
    pip               => undef,

    repeat_after     => 600,
    max_repeat_count => 0,
    server_side      => undef,
    try_client       => undef,
    alternative_code => undef,
};

my $STASH = {};

######
main();
######
sub main {
    my $logins_file_path = _get_args();
    my $app              = _get_app();
    my $res_file_path    = $logins_file_path;
    $res_file_path =~ s/\.csv$/_log\.json/;
    $STASH = get_stash($res_file_path);

    try {
        create_blocks($app, $logins_file_path);
    }
    catch {
        my ($e) = @_;
        save_stash($res_file_path);
        say $@;
        throw $e;
    };
    $app->post_run();
    save_stash($res_file_path);
}

sub create_blocks {
    my ($app, $logins_file_path) = @_;
    my $data_for_new_pages = _get_data_from_csv($logins_file_path);

    $BLOCK_SETTING_TEMPLATE->{'dsps'} = get_dsps($app);
    my $template_page_data = $app->video_an_site->get($TEMPALTE_PAGE_ID, fields => ['*']);

    foreach my $new_page_info (@$data_for_new_pages) {
        my $user_video_page =
          $app->video_an_site->get_all(filter =>
              ['AND', [['domain', '=', $new_page_info->{'domain'}], ['owner_id', '=', $new_page_info->{'id'}],]],);
        unless (@$user_video_page) {
            WARN
"CHECK THIS DATA login: $new_page_info->{'login'}, domain: $new_page_info->{'domain'}, owner_id: $new_page_info->{'id'}";
        }

        $template_page_data->{'login'}   = $new_page_info->{'login'};
        $template_page_data->{'domain'}  = $new_page_info->{'domain'};
        $template_page_data->{'caption'} = 'Video site caption';
        my $domain_key = $new_page_info->{'domain'} . '__' . $new_page_info->{'login'};
        my $page_id    = undef;
        if (!exists($STASH->{$domain_key})) {
            my %add_data = hash_transform($template_page_data, [keys(%{$app->video_an_site->get_add_fields()})]);
            $page_id = $app->video_an_site->add(%add_data);
            $STASH->{$domain_key} = {
                page_id       => $page_id,
                created       => TRUE,
                edited        => FALSE,
                start_testing => FALSE,
                start         => FALSE,
                block_added   => FALSE
            };

            say colored("\t\t insert page data: " . to_json(\%add_data), 'yellow');
        } else {
            $page_id = $STASH->{$domain_key}->{'page_id'};
        }

        if (!$STASH->{$domain_key}->{'edited'}) {
            my %edit_data = hash_transform($template_page_data, \@PAGE_EDIT_FIELDS);
            $app->video_an_site->do_action($page_id, 'edit', %edit_data);
            $STASH->{$domain_key}->{'edited'} = TRUE;
            say colored("\t\t\t edit page data: " . to_json(\%edit_data), 'yellow');
        }

        if (!$STASH->{$domain_key}->{'start_testing'}) {
            if ($app->video_an_site->maybe_do_action($page_id, 'start_testing')) {
                $STASH->{$domain_key}->{'start_testing'} = TRUE;
                say colored("\t\t\t start_testing page_id: $page_id", 'yellow');
            } else {
                $STASH->{$domain_key}->{'start_testing'} = FALSE;
                say colored("\t\t\t start_testing failed page_id: $page_id", 'yellow');
            }
        }

        if (!$STASH->{$domain_key}->{'start'} || $STASH->{$domain_key}->{'start'} ne 'started') {
            try {
                if ($app->video_an_site->maybe_do_action($page_id, 'start')) {
                    $STASH->{$domain_key}->{'start'} = 'started';
                    say colored("\t\t\t start page_id: $page_id", 'yellow');
                } else {
                    $STASH->{$domain_key}->{'start'} = 'failed';
                    say colored("\t\t\t start failed page_id: $page_id", 'yellow');
                }
            }
            catch Exception::Denied with {
                $STASH->{$domain_key}->{'start'} = $@->message;
                say colored("\t\t\t start page_id: $page_id error: " . $@->message, 'yellow');
            }
        }

        if (!$STASH->{$domain_key}->{'block_added'}) {
            $BLOCK_SETTING_TEMPLATE->{'page_id'} = $page_id;
            my $public_id = $app->video_an_site_instream->add(%$BLOCK_SETTING_TEMPLATE);
            $STASH->{$domain_key}->{'block_added'} = TRUE;
            say colored("\t\t insert block id: " . $public_id . "  data: " . to_json($BLOCK_SETTING_TEMPLATE),
                'bright_blue');
        }
    }
}

sub get_dsps {
    my ($app) = @_;
    my $dsps = $app->partner_db->dsp->get_all(
        fields => {dsp_id        => 'id',},
        filter => {short_caption => \@DSPS_SHORT_CAPTIONS},
    );
    map {
        $_->{'interval'}   = undef;
        $_->{'show_count'} = undef;
    } @$dsps;
    return $dsps;
}

sub _get_ids_by_logins {
    my ($app, $logins) = @_;
    return $app->users->get_all(
        fields => [qw(id)],
        filter => {login => $logins},
    );
}

sub _get_data_from_csv {
    my ($file_path) = @_;
    my $file_content = readfile($file_path);
    return parse_csv($file_content, sep_char => "\t");
}

sub _get_app {
    my $app = Application->new();
    $app->pre_run();
    $app->set_cur_user({id => 0});
    no strict 'refs';
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
    return $app;
}

sub get_stash {
    my ($res_file_path) = @_;
    my $content = eval {read_file($res_file_path, binmode => ':utf8')};
    my $data = eval {from_json($content)} // {};
    return $data;
}

sub save_stash {
    my ($res_file_path) = @_;
    my $content = eval {to_json($STASH, pretty => TRUE)};
    write_file($res_file_path, {binmode => ':utf8'}, \$content);
}

sub _get_args {

    my $file_path = '';
    my $help      = 0;
    Getopt::Long::GetOptions(
        #--- Obligatory
        'file_path=s' => \$file_path,
        #---
        'help|?|h' => \$help,
    ) or pod2usage(1);

    pod2usage(-verbose => 2, -noperldoc => 1) if $help;

    if (!$file_path) {
        print "specify the file path\n";
        pod2usage(-verbose => 2, -noperldoc => 1);
        exit(0);
    }

    return $file_path;
}
