#!/usr/bin/perl

=head1 DESCRIPTION
Скрипт Заполняет поля blocks_limit и blocks_count в необходимых таблицах.
Учитываются только рабочие блоки.
Сначала считается blocks_count, после этого в зависимости от того сколько блоков на пейдже,
выставляется ограничение.
=cut

# common modules
use feature 'say';

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

use PiConstants qw($TECHNICAL_RTB_BLOCK_ID);

my %PAGE_MODELS = (
    mobile_app_settings      => [qw(mobile_app_rtb)],
    context_on_site_campaign => [
        qw(context_on_site_adblock context_on_site_content context_on_site_direct context_on_site_rtb context_on_site_stripe)
    ],
    search_on_site_campaign => [qw(search_on_site_direct search_on_site_premium)],
    video_an_site           => [qw(video_an_site_fullscreen video_an_site_instream video_an_site_inpage)],
    indoor                  => [qw(indoor_block)],
    outdoor                 => [qw(outdoor_block)],
);

my $DEFAULT_LIMIT = 200;
my $id_excluded_1 = 0;

# main
sub main {
    my $app = Application->new();

    $app->pre_run();

    my $tmp_rights = $app->add_all_tmp_rights();

    #Заполняем blocks_count и blocks_limit
    foreach my $page_model (keys %PAGE_MODELS) {

        ldump $page_model;

        my $page_id_field_name = $app->$page_model->get_page_id_field_name();

        my $page_ids = $app->partner_db->$page_model->get_all(fields => [$page_id_field_name, 'id']);

        foreach my $page_id (@{$page_ids}) {

            if (defined $page_id->{$page_id_field_name}) {

                $app->partner_db->transaction(
                    sub {
                        my $blocks_limit_from_all_block_models = 0;

                        $app->partner_db->$page_model->get_all(
                            fields => [$page_id_field_name, 'id'],
                            filter     => {$page_id_field_name => $page_id->{$page_id_field_name}},
                            for_update => 1,
                        );

                        foreach my $block_model (@{$PAGE_MODELS{$page_model}}) {

                            my $page_id_field_name_for_block = $app->$block_model->get_page_id_field_name();

                            my $res = $app->partner_db->query->select(
                                table  => $app->partner_db->$block_model,
                                fields => {blocks_count => {count => ['id']}},
                                filter => [
                                    AND => [
                                        [$page_id_field_name_for_block => '=' => \$page_id->{$page_id_field_name},],
                                        [
                                            'multistate',
                                            'IN',
                                            \$app->$block_model->get_multistates_by_filter(
                                                'not deleted or deleted_with_page')
                                        ],
                                        [id => '<>' => \$id_excluded_1],
                                        [id => '<>' => \$TECHNICAL_RTB_BLOCK_ID],
                                    ]
                                ]
                            )->group_by($page_id_field_name_for_block)->get_all();

                            $blocks_limit_from_all_block_models += $res->[0]->{blocks_count} if defined $res->[0];
                        }
                        #Если блоков нет то ничего не делаем, иначе хэш
                        if ($blocks_limit_from_all_block_models < $DEFAULT_LIMIT) {

                            #Если количетсво блоков меньше 200, то изменяем только blocks_count, blocks_limit не трогаем

                            $app->partner_db->$page_model->edit($page_id->{'id'},
                                {blocks_count => $blocks_limit_from_all_block_models});

                        } else {

                            my $blocks_limit =
                              $blocks_limit_from_all_block_models + 100 - ($blocks_limit_from_all_block_models % 100);

                            #Лимит увеличиваем до ближайшей сотни.

                            $app->partner_db->$page_model->edit(
                                $page_id->{'id'},
                                {
                                    blocks_count => $blocks_limit_from_all_block_models,
                                    blocks_limit => $blocks_limit
                                }
                            );

                        }
                    }
                );
            }
        }
    }

    $app->post_run();
}
main();
__END__
