#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
    Скрипт фиксит поля stripe блоков
=cut

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    my $tmp_rights = $app->add_all_tmp_rights();

    foreach (qw(internal_context_on_site_stripe context_on_site_stripe)) {
        my $campaign_ids_for_type_id_2 = $app->partner_db->_get_all("SELECT campaign_id FROM $_ WHERE type_id=2;");

        my $campaign_ids_for_type_id_3 = $app->partner_db->_get_all("SELECT campaign_id FROM $_ WHERE type_id=3;");

        my $filter_for_id_2 =
          $app->partner_db->filter({campaign_id => [map {$_->{campaign_id}} @$campaign_ids_for_type_id_2]});
        $app->partner_db->$_->edit($filter_for_id_2, {interaction_id => 1, type_id => 1});

        my $filter_for_id_3 =
          $app->partner_db->filter({campaign_id => [map {$_->{campaign_id}} @$campaign_ids_for_type_id_3]});
        $app->partner_db->$_->edit($filter_for_id_3, {disposition_id => 1, type_id => 1});
    }

    $app->post_run();
}
main();
__END__
