#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
    Скрипт "копирует" пейджи и блоки с нескольких логинов на другой.

    Нужно подключить прод базу.
    Прод БК
    Прод Баланс
    Прод api_utils_partner2
    В конфиге выставить stage=production
=cut

# project modules
use lib::abs qw(
  ../../lib
  );

use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;
use Application;

my $STASH_PATH = './bin/oneshots/PI-14394_copy_rambler_pages.json';

my $YNDX_BLIZZARD = 198506264;

my $APP;

main();

# main
sub main {
    $APP = Application->new();
    $APP->pre_run();

    # fix avaialable_blocks
    $APP->set_option('cur_user' => {id => $YNDX_BLIZZARD});

    {
        no warnings 'redefine';
        no strict 'refs';

        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    my $stash = from_json(readfile($STASH_PATH));

    foreach my $login (sort keys(%$stash)) {
        my $models = $stash->{$login};

        foreach my $page_model (sort keys(%$models)) {
            my $pages = $models->{$page_model};

            foreach my $page_id (sort keys(%$pages)) {
                my $page = $pages->{$page_id};

                my $new_page_id = $page->{'new_page'}{'page_id'};

                diff_page($page_model, $page_id, $new_page_id);

                my $blocks = $page->{'blocks'};

                foreach my $block_model (sort keys(%$blocks)) {
                    foreach my $public_id (keys(%{$blocks->{$block_model}})) {
                        my $new_public_id = $blocks->{$block_model}{$public_id}{'new_block'}{'public_id'};

                        diff_block($block_model, $public_id, $new_public_id);
                    }
                }
            }
        }
    }

    $APP->post_run();

    done_testing();

    l '#END';
}

sub diff_page {
    my ($model, $page_id, $new_page_id) = @_;

    my $base = $APP->$model->get_all(fields => ['*'], filter => {page_id => $page_id})->[0];

    my $new = $APP->$model->get_all(fields => ['*'], filter => {page_id => $new_page_id})->[0];

    $new->{'banner_lang'}  = [sort @{$new->{'banner_lang'}}]  if exists($new->{'banner_lang'});
    $base->{'banner_lang'} = [sort @{$base->{'banner_lang'}}] if exists($base->{'banner_lang'});

    my %global_excluded_domains = map {$_ => TRUE} @{$new->{'global_excluded_domains'}};
    my @lost_domains = grep {!$global_excluded_domains{$_}} @{$base->{'global_excluded_domains'}};
    throw 'global_excluded_domains ' . to_json(\@lost_domains) if @lost_domains;

    #новый блок нужно переотправить
    delete($new->{'actions'}{'start_update'});
    delete($base->{'status'});
    delete($new->{'status'});

    throw 'multistate' unless int($new->{'multistate'}) & int($base->{'multistate'});

    # block_title '' vs undef
    $new->{'block_title'}  //= '';
    $base->{'block_title'} //= '';

    # fix mirrors
    $base->{'mirrors'} = _normolize_mirrors($base->{'mirrors'});
    $new->{'mirrors'}  = _normolize_mirrors($new->{'mirrors'});

    # metrica_counter
    delete($base->{'metrica_counter'});
    delete($new->{'metrica_counter'});

    # quality_coef новый для новых пейджей
    delete($base->{'quality_coef'});
    delete($new->{'quality_coef'});
    # ya_categories
    delete($base->{'ya_categories'});
    delete($new->{'ya_categories'});

    #TODO: нужно перенести global_excluded_domains?
    $base->{'global_excluded_domains'} = $new->{'global_excluded_domains'};

    # context_on_site_direct_count - не переносим
    # context_on_site_adblock_count - не переносим
    delete($base->{'context_on_site_direct_count'});
    delete($base->{'context_on_site_adblock_count'});
    delete($new->{'context_on_site_direct_count'});
    delete($new->{'context_on_site_adblock_count'});

    # available_levels нет Директа так как не переносим
    $base->{'available_levels'} = $new->{'available_levels'};

    # pi_id не переносим
    delete($base->{'pi_id'});
    delete($new->{'pi_id'});

    foreach (
        qw(id page_id public_id send_time update_time create_date multistate multistate_name owner login owner_id client_id)
      )
    {
        delete($base->{$_});
        delete($new->{$_});
    }

    eq_or_diff($new, $base, "page_id: $page_id", {context => 1});
}

sub _normolize_mirrors {
    my ($mirrors) = @_;

    my $ref    = FALSE;
    my @result = ();
    foreach (@$mirrors) {
        if (ref($_)) {
            $ref = TRUE;

            next if $_->{'moderation_status'} ne 'approved';

            $_->{'auto'}        = 0;
            $_->{'campaign_id'} = 0;
            $_->{'multistate'}  = 0;
            $_->{'domain'}      = lc($_->{'domain'});
        }

        push(@result, $_);
    }

    return $ref ? [sort {$a->{'domain'} cmp $b->{'domain'}} @result] : [sort @result];
}

sub diff_block {
    my ($model, $public_id, $new_public_id) = @_;

    my $base = $APP->$model->get($public_id, fields => ['*']);

    my $new = $APP->$model->get($new_public_id, fields => ['*']);

    foreach (
        qw(campaign page campaign_id internal_campaign_id login create_date owner_client_id owner_id page_id public_id))
    {
        delete($base->{$_});
        delete($new->{$_});
    }

    eq_or_diff($new, $base, "public_id: $public_id", {context => 1});
}

__END__
